
//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
Texture2D overlay;            //

int mode;
float    g_fTime;                   // App's time in seconds
int overlay_Width;
int overlay_Height;
int dst_Width;
int dst_Height;


//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
SamplerState TextureSampler
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Wrap;
    AddressV = Wrap;

};

struct VS_INPUT
{
    float4 Position   : POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD0;   // vertex texture coords 
};

struct VS_OUTPUT
{
    float4 Position   : SV_POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD1;   // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : SV_Target;  // Pixel color
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------

#define EQN_EPS 1e-9f

static bool isZero(float x) {
	return (x > -EQN_EPS && x < EQN_EPS);
}

static int2 float2toint2(float2 tc,int w,int h)
{

	tc = clamp(tc, 0.0, 1.0); 
	int2 tcInt;

	tcInt.x = int(tc.x * w ); 
	tcInt.y = int(tc.y * h );
	tcInt.x = clamp(tcInt.x, 0, w - 1);
    tcInt.y = clamp(tcInt.y, 0, h - 1);
	return tcInt;
}


static float2 int2tofloat2(int2 tc,float w, float h)
{
	if (w == 0.0f || h == 0.0f) {
		return float2(0.0f, 0.0f);
	}

	tc.x = clamp(tc.x, 0, int(w-1));
	tc.y = clamp(tc.y, 0, int(h-1));

	float2 tcfloat2 = float2((float(tc.x) + 0.5f) / w, (float(tc.y) + 0.5f) / h);
	return tcfloat2;
}

static float minmax(int y, int min, int max)
{
	if (y > max) 
		y = max;
	else if (y < min)
		y = min;
	return float(y);
}
PS_OUTPUT PS_2D( VS_OUTPUT In)
{ 
    PS_OUTPUT Output;
    int width = overlay_Width;
    int height = overlay_Height;
    float ow = float(overlay_Width);
    float oh = float(overlay_Height);
    float bw = float(dst_Width);
    float bh = float(dst_Height);
    float2 tc = In.TextureUV;
	float4 yuv = float4(0.0,0.0,0.0,0.0);     
	int2 tcInt= float2toint2(tc, overlay_Width, overlay_Height);
	int2 tcInt00 = int2(0, 0);
    if(mode == 0 && tcInt.y < (overlay_Height / 4)){
		
		tcInt00.x = (tcInt.x *4 + tcInt.y * dst_Width*4 ) % overlay_Width;
		tcInt00.y = (tcInt.x *4 + tcInt.y * dst_Width*4 ) / overlay_Width;
		if(tcInt00.x >= overlay_Width )
		{
			tcInt00.x = overlay_Width -1;
		}
		if(tcInt00.y >= overlay_Height )
		{
			tcInt00.y = overlay_Height -1;
		}
		
		int2 tcInt01 = int2(tcInt00.x + 1,tcInt00.y);
		int2 tcInt02 = int2(tcInt00.x + 2,tcInt00.y);
		int2 tcInt03 = int2(tcInt00.x + 3,tcInt00.y);
		
		float2 normalizedTC00 = int2tofloat2(tcInt00, bw, bh);
		float2 normalizedTC01 = int2tofloat2(tcInt01, bw, bh);
		float2 normalizedTC02 = int2tofloat2(tcInt02, bw, bh);
		float2 normalizedTC03 = int2tofloat2(tcInt03, bw, bh);
		
		float4 img00 = overlay.Sample(TextureSampler, normalizedTC00) * 255.0f;;
		float4 img01 = overlay.Sample(TextureSampler, normalizedTC01) * 255.0f;;
		float4 img02 = overlay.Sample(TextureSampler, normalizedTC02) * 255.0f;;
		float4 img03 = overlay.Sample(TextureSampler, normalizedTC03) * 255.0f;;
		
		// img00.xyz = img00.zyx;
		// img01.xyz = img01.zyx;
		// img02.xyz = img02.zyx;
		// img03.xyz = img03.zyx;
	
  
		//bt709 fullrange
		yuv.z = 0.2126 * img00.x + 0.715200f * img00.y + 0.0722f * img00.z;
		yuv.y = 0.2126 * img01.x + 0.715200f * img01.y + 0.0722f * img01.z;
		yuv.x = 0.2126 * img02.x + 0.715200f * img02.y + 0.0722f * img02.z;
		yuv.w = 0.2126 * img03.x + 0.715200f * img03.y + 0.0722f * img03.z;
		
	
		yuv.x = minmax(int(yuv.x + 0.5), 0, 255);
		yuv.y = minmax(int(yuv.y + 0.5), 0, 255);
		yuv.z = minmax(int(yuv.z + 0.5), 0, 255);
		yuv.w = minmax(int(yuv.w + 0.5), 0, 255);

	}
	else if (mode == 0 && tcInt.y >= (overlay_Height / 4)  && tcInt.y < (overlay_Height * 5 / 4)){
		///tc.y = tc.y - 0.25f;
		int2 tcIntUV = float2toint2(tc,overlay_Width,overlay_Height);
		tcIntUV.y = tcInt.y - overlay_Height / 4;
		tcIntUV.x = tcInt.x;

		tcInt00.x = (tcIntUV.x *4 + tcIntUV.y * dst_Width * 4 ) % overlay_Width;
		tcInt00.y = (tcIntUV.x *4 + tcIntUV.y * dst_Width * 4 ) / overlay_Width; 
		tcInt00.y = tcInt00.y * 2;
		
		if(tcInt00.x >= overlay_Width )
		{
			tcInt00.x = overlay_Width - 1;
		}
		if(tcInt00.y >= overlay_Height )
		{
			tcInt00.y = overlay_Height -1;
		}
		int2 tcInt01 = int2(tcInt00.x + 2,tcInt00.y);
		
		float2 normalizedTC00 = int2tofloat2(tcInt00, bw, bh);
		float2 normalizedTC01 = int2tofloat2(tcInt01, bw, bh);
		
		float4 img00 = overlay.Sample(TextureSampler, normalizedTC00) * 255.0f;
		float4 img01 = overlay.Sample(TextureSampler, normalizedTC01) * 255.0f;

		// img00.xyz = img00.zyx;
		// img01.xyz = img01.zyx;

        yuv.z = -0.114572f*img00.x - 0.385428f*img00.y + 0.5000f*img00.z + 128.0f;
        yuv.y =  0.5000f*img00.x - 0.454153f*img00.y - 0.045847f*img00.z + 128.0f;
	   
        yuv.x = -0.114572f*img01.x - 0.385428f*img01.y + 0.5000f*img01.z + 128.0f;
        yuv.w = 0.5000f*img01.x - 0.454153f*img01.y - 0.045847f*img01.z + 128.0f;
	
		yuv.x = minmax(int(yuv.x + 0.5), 0, 255);
		yuv.y = minmax(int(yuv.y + 0.5), 0, 255);
		yuv.z = minmax(int(yuv.z + 0.5), 0, 255);
		yuv.w = minmax(int(yuv.w + 0.5), 0, 255);
    }
    yuv  = yuv / 255.0;
    Output.RGBColor = yuv;
	return Output;
}

// 
VS_OUTPUT VS_2D(VS_INPUT vin)
{
	VS_OUTPUT vOut;
	vOut.Position = vin.Position ;
	vOut.TextureUV = vin.TextureUV;
	return vOut;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target using D3D11 Techniques
//--------------------------------------------------------------------------------------
technique11 ColorTech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D()));

	}
}

