
#define BITONIC_BLOCK_SIZE 16

cbuffer CB : register( b0 )
{
	 uint width;
	 uint height;
	 uint shift;
	 uint nothing2;
};

RWTexture2D<uint> outputtextureY : register(u0);
RWTexture2D<uint2> outputtextureUV : register(u1);
Texture2D<uint> inputTextureY: register(t0);
Texture2D<uint2> inputTextureUV: register(t1);


[numthreads(BITONIC_BLOCK_SIZE, BITONIC_BLOCK_SIZE, 1)]
void P010ToNV12( uint3 Gid : SV_GroupID, 
                  uint3 DTid : SV_DispatchThreadID, 
                  uint3 GTid : SV_GroupThreadID, 
                  uint GI : SV_GroupIndex )
{
	if (DTid.x > width || DTid.y > height)
	{
		return;			
	}
	uint2 position = DTid.xy;
	if(shift > 0)
	{
		if (DTid.y < height / 2)
		{
			uint2 pix = inputTextureUV[position];
			outputtextureUV[position] = (uint2)((pix >> 8) & 0xff);
		}
		uint pix = inputTextureY[position];
		outputtextureY[position] = (uint)((pix >> 8) & 0xff);
	}
	if(shift <= 0)
	{
		if (DTid.y < height / 2)
		{
			uint pix = inputTextureUV[position];
			outputtextureUV[position] = (uint)((pix >> 2) & 0xff);
		}
		uint pix = inputTextureY[position];
		outputtextureY[position] = (uint)((pix >> 2) & 0xff);
	}
	
}


