import urllib.parse
import facebook
import facebookads
from facebookads.objects import *
from facebookads.exceptions import FacebookRequestError
from baseau import *

class FacebookAU(BaseAU):
    def __init__(self):
        BaseAU.__init__(self)
        self.scope = ['email', 'user_photos', 'user_posts', 'user_videos', 'publish_stream', 'publish_actions']
        self.graph = None
        self.userInfo = []

    def start_upload(self):
        if self.graph == None:
            self.SendMessage(4, self.accessError)
            return
        gSession = facebookads.FacebookSession(self.appId, self.appSecret, self.accessToken)
        facebookads.FacebookAdsApi.set_default_api(facebookads.FacebookAdsApi(gSession))
        try:
            video = AdVideo(parent_id=self.userInfo['id'])
            video[AdVideo.Field.filepath] = self.filepath
            video[AdVideo.Field.title] = self.title
            video[AdVideo.Field.description] = self.desc
            response = video.remote_create(uploadparam = self)
            self.SendMessage(2, 'https://www.facebook.com/' + video._data['id'])
        except FacebookRequestError as e:
            self.SendMessage(3, str(e.body()))
        except KeyError:
            self.SendMessage(3, 'Wrong user id.')
        except Exception as e:
            self.SendMessage(3, str(e))

    def SetBrand(self, brand):
        if brand == 'wondershare':
            self.appId = '285815644859389'
            self.appSecret = '8c4af54e67dc07307ab80766383d0613'
            self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'
            #self.appId = '1731678833712743'
            #self.appSecret = 'c748ba633c146dd56d65bd0023ef401c'
            #self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'
        elif brand == 'iskysoft':
            self.appId = '917705148272157'
            self.appSecret = '30a92fa36eeae4da1d1ef2e5a54606df'
            self.redirectURL = 'http://filmora.iskysoft.com/redirect'

    def GetLoginURL(self):
        facebook_authorization_url = facebook.auth_url(self.appId, self.redirectURL, self.scope, response_type='token')
        return facebook_authorization_url

    def Logout(self):
        if self.graph != None:
            response = self.graph.request(path='/me/permissions', method='DELETE')
            debug(response)

    def VerifyRedirectURL(self, url):
        x_url = str(self.redirectURL)
        if x_url.__contains__('http://'):
            x_url = x_url.replace('http://', '')
        if url.index(x_url.replace('http://', '')) > 0:
            uri = urllib.parse.urlparse(url)
            fragment = urllib.parse.parse_qs(uri.fragment)
            paramlist = urllib.parse.parse_qs(uri.query)
            if 'access_token' in fragment:
                if self.SetAccessToken(fragment['access_token'][0]) == True:
                    return 0
            if 'error_code' in paramlist:
                if 'error_description' in paramlist:
                    self.accessError = paramlist['error_description'][0]
                elif 'error_message' in paramlist:
                    self.accessError = paramlist['error_message'][0]
                elif 'error' in paramlist:
                    self.accessError = paramlist['error'][0]
                self.accessError = '(' + paramlist['error_code'][0] + ') ' + self.accessError
            return BaseAU.VerifyCode.E_FAILED
        return BaseAU.VerifyCode.E_INVALIDARG

    def SetAccessToken(self, token):
        self.accessToken = token
        try:
            self.graph = facebook.GraphAPI(self.accessToken)
            self.userInfo = self.graph.get_object("me")
            self.userName = self.userInfo['name']
            return True
        except facebook.GraphAPIError as e:
            self.graph = None
            self.accessError = e.message
            print((e.message))
        return False

def CreateFacebookInstance():
    return FacebookAU()

if __name__ == '__main__':
    facebookau = CreateFacebookInstance()
    facebookau.SetBrand('wondershare')
    print(facebookau.GetLoginURL())
    c = input('input :')
    facebookau.VerifyRedirectURL(c)
    #facebookau.SetAccessToken('CAAED8qP7qZC0BAHCLIyFRZAeIIVmRwewrwrZAMJiEZCbZApvahWfT4SIc8jsR4I80GwXX4mYRJDyLUuRthlZC9sYZAIN5zoobFMM7i7kaBHfxy0lYHKGfZBxZAmDVkpToMxKK4CZBxtnHSeNDr7uOOIqNFRv7mSB9aod0pB8tOW2o7RCvZCEgnkx5xah7E3dtvkZBFMZC4e5p1sKJ5QZDZD')
    print(facebookau.GetUserName())
    # facebookau.Logout()
    facebookau.StartUpload(r'E:\MySource\python\py3_2\v\2.mp4', 'Hello xbx', 'xbx desc', '', 'wondershare filmora', 'public')
