/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrizedWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public final class RuntimeUtils {
    private static final Log log = Log.getLog(RuntimeUtils.class);
    private static final boolean IS_WINDOWS = Platform.getOS().equals("win32");
    private static final boolean IS_MACOS = Platform.getOS().equals("macosx");
    private static final boolean IS_LINUX = Platform.getOS().equals("linux");
    private static final boolean IS_GTK = Platform.getWS().equals("gtk");
    private static final byte[] NULL_MAC_ADDRESS = new byte[6];

    private RuntimeUtils() {
    }

    public static <T> T getObjectAdapter(Object adapter, Class<T> objectType) {
        return (T)Platform.getAdapterManager().getAdapter(adapter, objectType);
    }

    public static <T> T getObjectAdapter(Object adapter, Class<T> objectType, boolean force) {
        IAdapterManager adapterManager = Platform.getAdapterManager();
        if (force) {
            adapterManager.loadAdapter(adapter, objectType.getName());
        }
        return (T)adapterManager.getAdapter(adapter, objectType);
    }

    /*
     * WARNING - void declaration
     */
    public static DBRProgressMonitor makeMonitor(IProgressMonitor monitor) {
        void var2_1;
        DBRProgressMonitor dBRProgressMonitor;
        IProgressMonitor iProgressMonitor = monitor;
        if (iProgressMonitor instanceof DBRProgressMonitor && (dBRProgressMonitor = (DBRProgressMonitor)iProgressMonitor) == (DBRProgressMonitor)var2_1) {
            void monitor1;
            return monitor1;
        }
        return new DefaultProgressMonitor(monitor);
    }

    /*
     * WARNING - void declaration
     */
    public static IProgressMonitor getNestedMonitor(DBRProgressMonitor monitor) {
        void var2_1;
        IProgressMonitor iProgressMonitor;
        DBRProgressMonitor dBRProgressMonitor = monitor;
        if (dBRProgressMonitor instanceof IProgressMonitor && (iProgressMonitor = (IProgressMonitor)dBRProgressMonitor) == (IProgressMonitor)var2_1) {
            void monitor1;
            return monitor1;
        }
        return monitor.getNestedMonitor();
    }

    public static File getUserHomeDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = ".";
        }
        return new File(userHome);
    }

    public static String getCurrentDate() {
        return new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH).format(new Date());
    }

    public static String getCurrentTimeStamp() {
        return new SimpleDateFormat("yyyyMMddHHmm", Locale.ENGLISH).format(new Date());
    }

    public static boolean isTypeSupported(Class<?> type, Class<?>[] supportedTypes) {
        if (type == null || ArrayUtils.isEmpty((Object[])supportedTypes)) {
            return false;
        }
        Class<?>[] classArray = supportedTypes;
        int n = supportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> tmp = classArray[n2];
            if (tmp.isAssignableFrom(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getNativeBinaryName(String binName) {
        return RuntimeUtils.isWindows() ? String.valueOf(binName) + ".exe" : binName;
    }

    public static File getNativeClientBinary(@NotNull DBPNativeClientLocation home, @Nullable String binFolder, @NotNull String binName) throws IOException {
        binName = RuntimeUtils.getNativeBinaryName(binName);
        File dumpBinary = new File(home.getPath(), binFolder == null ? binName : String.valueOf(binFolder) + "/" + binName);
        if (!dumpBinary.exists() && !(dumpBinary = new File(home.getPath(), binName)).exists()) {
            throw new IOException("Utility '" + binName + "' not found in client home '" + home.getDisplayName() + "' (" + home.getPath().getAbsolutePath() + ")");
        }
        return dumpBinary;
    }

    @NotNull
    public static IStatus stripStack(@NotNull IStatus status) {
        if (status instanceof MultiStatus) {
            IStatus[] children = status.getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    children[i] = RuntimeUtils.stripStack(children[i]);
                    ++i;
                }
            }
            return new MultiStatus(status.getPlugin(), status.getCode(), children, status.getMessage(), null);
        }
        if (status instanceof Status) {
            if (status.getException() != null && CommonUtils.isEmpty((String)status.getException().getMessage())) {
                String messagePrefix = String.valueOf(status.getException().getClass().getName()) + ": ";
                return new Status(status.getSeverity(), status.getPlugin(), status.getCode(), String.valueOf(messagePrefix) + status.getMessage(), null);
            }
            return status;
        }
        return status;
    }

    public static void pause(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.debug("Sleep interrupted", e);
        }
    }

    public static String formatExecutionTime(long ms) {
        if (ms < 1000L) {
            return String.valueOf(String.valueOf(ms)) + "ms";
        }
        if (ms < 60000L) {
            return String.valueOf(String.valueOf(ms / 1000L)) + "." + String.valueOf(ms % 1000L) + "s";
        }
        long sec = ms / 1000L;
        long min = sec / 60L;
        return String.valueOf(String.valueOf(min)) + "m " + String.valueOf(sec -= min * 60L) + "s";
    }

    @NotNull
    public static String formatExecutionTimeShort(@NotNull Duration duration) {
        long min = duration.toMinutes();
        long sec = duration.toSecondsPart();
        if (min > 0L) {
            return "%dm %ds".formatted(min, sec);
        }
        return "%ds".formatted(sec);
    }

    public static File getPlatformFile(String platformURL) throws IOException {
        URL url = new URL(platformURL);
        URL fileURL = FileLocator.toFileURL((URL)url);
        return RuntimeUtils.getLocalFileFromURL(fileURL);
    }

    public static File getLocalFileFromURL(URL fileURL) throws IOException {
        try {
            URI filePath = GeneralUtils.makeURIFromFilePath(fileURL.toString());
            if (filePath.getAuthority() != null) {
                return new File(filePath.getSchemeSpecificPart());
            }
            return new File(filePath);
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad local file path: " + fileURL, e);
        }
    }

    public static Path getLocalPathFromURL(URL fileURL) throws IOException {
        try {
            URI filePath = GeneralUtils.makeURIFromFilePath(fileURL.toString());
            if (filePath.getAuthority() != null) {
                return Path.of(filePath.getSchemeSpecificPart(), new String[0]);
            }
            return Path.of(filePath);
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad local file path: " + fileURL, e);
        }
    }

    public static boolean runTask(DBRRunnableWithProgress task, String taskName, long waitTime) {
        return RuntimeUtils.runTask(task, taskName, waitTime, false);
    }

    public static boolean runTask(DBRRunnableWithProgress task, String taskName, long waitTime, boolean hidden) {
        final MonitoringTask monitoringTask = new MonitoringTask(task);
        AbstractJob monitorJob = new AbstractJob(taskName, hidden){
            {
                super($anonymous0);
                this.setSystem(bl);
                this.setUser(!bl);
            }

            @Override
            protected IStatus run(DBRProgressMonitor monitor) {
                monitor.beginTask(this.getName(), 1);
                try {
                    try {
                        monitor.subTask("Execute task");
                        monitoringTask.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        log.error(String.valueOf(this.getName()) + " - error", e.getTargetException());
                        IStatus iStatus = Status.OK_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        monitorJob.schedule();
        boolean headlessMode = DBWorkbench.getPlatform().getApplication().isHeadlessMode();
        long startTime = System.currentTimeMillis();
        while (!monitoringTask.finished) {
            if (waitTime > 0L && System.currentTimeMillis() - startTime > waitTime) break;
            try {
                if (!headlessMode && DBWorkbench.getPlatformUI().readAndDispatchEvents()) continue;
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                log.debug("Task '" + taskName + "' was interrupted");
                break;
            }
        }
        return monitoringTask.finished;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String executeProcess(String binPath, String ... args) throws DBException {
        try {
            Object[] cmdBin = new String[]{binPath};
            Object[] cmd = args == null ? cmdBin : (String[])ArrayUtils.concatArrays((Object[])cmdBin, (Object[])args);
            Process p = Runtime.getRuntime().exec((String[])cmd);
            try {
                StringBuilder out = new StringBuilder();
                RuntimeUtils.readStringToBuffer(p.getInputStream(), out);
                if (out.length() == 0) {
                    StringBuilder err = new StringBuilder();
                    RuntimeUtils.readStringToBuffer(p.getErrorStream(), err);
                    String string = err.toString();
                    return string;
                }
                String string = out.toString();
                return string;
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            throw new DBException("Error executing process " + binPath, ex);
        }
    }

    public static String executeProcessAndCheckResult(String binPath, String ... args) throws DBException {
        try {
            Object[] cmdBin = new String[]{binPath};
            Object[] cmd = args == null ? cmdBin : (String[])ArrayUtils.concatArrays((Object[])cmdBin, (Object[])args);
            Process p = Runtime.getRuntime().exec((String[])cmd);
            return RuntimeUtils.getProcessResults(p);
        }
        catch (Exception ex) {
            if (ex instanceof DBException cmd) {
                throw dbe;
            }
            throw new DBException("Error executing process " + binPath, ex);
        }
    }

    @NotNull
    public static String getProcessResults(Process p) throws IOException, InterruptedException, DBException {
        try {
            StringBuilder out = new StringBuilder();
            RuntimeUtils.readStringToBuffer(p.getInputStream(), out);
            StringBuilder err = new StringBuilder();
            RuntimeUtils.readStringToBuffer(p.getErrorStream(), err);
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new DBException(err.toString());
            }
            String string = out.toString();
            return string;
        }
        finally {
            p.destroy();
        }
    }

    private static void readStringToBuffer(InputStream is, StringBuilder out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader input = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = input.readLine()) != null) {
                if (out.length() > 0) {
                    out.append("\n");
                }
                out.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isWindowsStoreApplication() {
        if (!IS_WINDOWS) {
            return false;
        }
        String property = System.getProperty("dbeaver.windows.store.app");
        return property != null && property.equalsIgnoreCase("true");
    }

    public static boolean isMacOS() {
        return IS_MACOS;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static boolean isGtk() {
        return IS_GTK;
    }

    public static void setThreadName(String name) {
        Thread.currentThread().setName("DBeaver: " + name);
    }

    public static byte[] getLocalMacAddress() throws IOException {
        Enumeration<NetworkInterface> niEnum;
        InetAddress localHost = InetAddress.getLocalHost();
        NetworkInterface ni = NetworkInterface.getByInetAddress(localHost);
        if (ni == null && (niEnum = NetworkInterface.getNetworkInterfaces()).hasMoreElements()) {
            ni = niEnum.nextElement();
        }
        return ni == null ? NULL_MAC_ADDRESS : ni.getHardwareAddress();
    }

    @NotNull
    public static List<String> splitCommandLine(@NotNull String input, boolean escapesSupported) {
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder argument = new StringBuilder();
        CommandLineState state = CommandLineState.NONE;
        boolean escaped = false;
        int index = 0;
        while (index < input.length()) {
            char quote;
            char ch = input.charAt(index);
            char c = quote = state == CommandLineState.SINGLE_QUOTE ? (char)'\'' : '\"';
            if (escaped) {
                argument.append(ch);
                escaped = false;
            } else {
                switch (state) {
                    case NONE: 
                    case NORMAL: {
                        if (ch == '\'') {
                            state = CommandLineState.SINGLE_QUOTE;
                            break;
                        }
                        if (ch == '\"') {
                            state = CommandLineState.DOUBLE_QUOTE;
                            break;
                        }
                        if (ch == '\\' && escapesSupported) {
                            escaped = true;
                            state = CommandLineState.NORMAL;
                            break;
                        }
                        if (!Character.isWhitespace(ch)) {
                            argument.append(ch);
                            state = CommandLineState.NORMAL;
                            break;
                        }
                        if (state != CommandLineState.NORMAL) break;
                        arguments.add(argument.toString());
                        argument.setLength(0);
                        state = CommandLineState.NONE;
                        break;
                    }
                    case SINGLE_QUOTE: 
                    case DOUBLE_QUOTE: {
                        if (ch == '\\' && escapesSupported) {
                            char next;
                            if ((next = input.charAt(++index)) != quote && next != '\\') {
                                argument.append(ch);
                            }
                            argument.append(next);
                            break;
                        }
                        if (ch == quote) {
                            state = CommandLineState.NORMAL;
                            break;
                        }
                        argument.append(ch);
                        break;
                    }
                }
            }
            ++index;
        }
        if (escaped) {
            argument.append('\\');
            arguments.add(argument.toString());
        } else if (state != CommandLineState.NONE) {
            arguments.add(argument.toString());
        }
        return arguments;
    }

    @NotNull
    public static String getWorkingDirectory(String defaultWorkspaceLocation) {
        String workingDirectory;
        String osName = System.getProperty("os.name").toUpperCase();
        if (osName.contains("WIN")) {
            String appData = System.getenv("AppData");
            if (appData == null) {
                appData = System.getProperty("user.home");
            }
            workingDirectory = String.valueOf(appData) + "\\" + defaultWorkspaceLocation;
        } else if (osName.contains("MAC")) {
            workingDirectory = String.valueOf(System.getProperty("user.home")) + "/Library/" + defaultWorkspaceLocation;
        } else {
            String dataHome = System.getProperty("XDG_DATA_HOME");
            if (dataHome == null) {
                dataHome = String.valueOf(System.getProperty("user.home")) + "/.local/share";
            }
            String badWorkingDir = String.valueOf(dataHome) + "/." + defaultWorkspaceLocation;
            String goodWorkingDir = String.valueOf(dataHome) + "/" + defaultWorkspaceLocation;
            workingDirectory = !new File(goodWorkingDir).exists() && new File(badWorkingDir).exists() ? badWorkingDir : goodWorkingDir;
        }
        return workingDirectory;
    }

    public static ResourceBundle getBundleLocalization(Bundle bundle, String locale) throws MissingResourceException {
        ServiceCaller localizationTracker;
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new MissingResourceException(CommonMessages.activator_resourceBundleNotStarted, bundle.getSymbolicName(), "");
        }
        try {
            localizationTracker = (ServiceCaller)BeanUtils.getFieldValue((Object)activator, (String)"localizationTracker");
        }
        catch (Throwable e) {
            throw new MissingResourceException(NLS.bind((String)CommonMessages.activator_resourceBundleNotFound, (Object)locale), bundle.getSymbolicName(), e.getMessage());
        }
        BundleLocalization location = localizationTracker.current().orElse(null);
        ResourceBundle result = null;
        if (location != null) {
            result = location.getLocalization(bundle, locale);
        }
        if (result == null) {
            throw new MissingResourceException(NLS.bind((String)CommonMessages.activator_resourceBundleNotFound, (Object)locale), bundle.getSymbolicName(), "");
        }
        return result;
    }

    public static <T> void executeJobsForEach(List<T> objects, final DBRRunnableParametrizedWithProgress<T> task) {
        JobGroup jobGroup = new JobGroup("executeJobsForEach:" + objects, 10, 1);
        for (final T object : objects) {
            AbstractJob job = new AbstractJob("Execute for " + object){
                {
                    super($anonymous0);
                    this.setSystem(true);
                    this.setUser(false);
                }

                @Override
                protected IStatus run(DBRProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        try {
                            task.run(monitor, object);
                        }
                        catch (InvocationTargetException e) {
                            log.debug(e.getTargetException());
                        }
                        catch (InterruptedException interruptedException) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setJobGroup(jobGroup);
            job.schedule();
        }
        try {
            jobGroup.join(0L, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException interruptedException) {}
    }

    private static enum CommandLineState {
        NONE,
        NORMAL,
        SINGLE_QUOTE,
        DOUBLE_QUOTE;

    }

    private static class MonitoringTask
    implements DBRRunnableWithProgress {
        private final DBRRunnableWithProgress task;
        private DBRProgressMonitor monitor;
        volatile boolean finished;

        private MonitoringTask(DBRRunnableWithProgress task) {
            this.task = task;
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.monitor = monitor;
            try {
                this.task.run(monitor);
            }
            finally {
                this.finished = true;
            }
        }
    }
}

