/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class ListNode<T>
implements Iterable<T> {
    public final ListNode<T> next;
    public final T data;

    private ListNode(@Nullable ListNode<T> next, T data) {
        this.next = next;
        this.data = data;
    }

    public static <T> boolean hasAny(@Nullable ListNode<T> list) {
        return list != null;
    }

    public static <T> boolean hasOne(@Nullable ListNode<T> list) {
        return list != null && list.next == null;
    }

    public static <T> boolean hasMany(@Nullable ListNode<T> list) {
        return list != null && list.next != null;
    }

    @NotNull
    public static <T> ListNode<T> of(@NotNull T data) {
        return new ListNode<T>(null, data);
    }

    @NotNull
    public static <T> ListNode<T> of(@NotNull T data1, @NotNull T data2) {
        return new ListNode<T>(new ListNode<T>(null, data1), data2);
    }

    @NotNull
    public static <T> ListNode<T> push(@Nullable ListNode<T> node, @NotNull T data) {
        return new ListNode<T>(node, data);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private ListNode<T> node;
            {
                this.node = ListNode.this;
            }

            @Override
            public boolean hasNext() {
                return this.node != null;
            }

            @Override
            @NotNull
            public T next() {
                if (this.node != null) {
                    Object result = this.node.data;
                    this.node = this.node.next;
                    return result;
                }
                throw new NoSuchElementException();
            }
        };
    }
}

