/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;

public class DBNFileSystemRoot
extends DBNPathBase
implements DBNLazyNode {
    private static final Log log = Log.getLog(DBNFileSystemRoot.class);
    private DBFVirtualFileSystemRoot root;
    private Path path;

    public DBNFileSystemRoot(DBNFileSystem parentNode, DBFVirtualFileSystemRoot root) {
        super(parentNode);
        this.root = root;
    }

    @NotNull
    public DBFVirtualFileSystemRoot getRoot() {
        return this.root;
    }

    @Override
    public boolean isDisposed() {
        return this.root == null || super.isDisposed();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.root = null;
        super.dispose(reflect);
    }

    @Override
    public String getNodeType() {
        return String.valueOf(DBNNode.NodePathType.dbvfs.name()) + ".folder";
    }

    @Override
    public String getNodeTypeLabel() {
        return ModelMessages.fs_folder;
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeName() {
        return this.root.getName();
    }

    @Override
    public String getNodeDescription() {
        return null;
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FOLDER_INFO;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Override
    public synchronized Path getPath() {
        if (this.path == null) {
            try {
                this.path = this.root.getRootPath(new VoidProgressMonitor());
            }
            catch (DBException e) {
                log.error("Error resolving file system root", e);
                return Path.of(".nonexistentfolder", new String[0]);
            }
        }
        return this.path;
    }

    @Override
    protected synchronized void setPath(Path path) {
        this.path = path;
    }
}

