/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBNModel
implements IResourceChangeListener {
    public static final String SLASH_ESCAPE_TOKEN = "%2F";
    private static final Log log = Log.getLog(DBNModel.class);
    private final DBPPlatform platform;
    private final List<? extends DBPProject> modelProjects;
    private DBNRoot root;
    private final List<INavigatorListener> listeners = new ArrayList<INavigatorListener>();
    private transient INavigatorListener[] listenersCopy = null;
    private final transient List<DBNEvent> eventCache = new ArrayList<DBNEvent>();
    private final Map<DBSObject, Object> nodeMap = new HashMap<DBSObject, Object>();
    private final List<Function<DBNNode, Boolean>> nodeFilters = new ArrayList<Function<DBNNode, Boolean>>();
    private SMSessionContext modelAuthContext;

    public DBNModel(DBPPlatform platform, @Nullable List<? extends DBPProject> modelProjects) {
        this.platform = platform;
        this.modelProjects = modelProjects;
    }

    public DBPPlatform getPlatform() {
        return this.platform;
    }

    @Nullable
    public List<? extends DBPProject> getModelProjects() {
        return this.modelProjects;
    }

    public SMSessionContext getModelAuthContext() {
        return this.modelAuthContext;
    }

    public void setModelAuthContext(SMSessionContext modelAuthContext) {
        this.modelAuthContext = modelAuthContext;
    }

    public boolean isGlobal() {
        return this.modelProjects == null;
    }

    public void initialize() {
        if (this.root != null) {
            throw new IllegalStateException("Can't initialize navigator model more than once");
        }
        this.root = new DBNRoot(this);
        if (this.isGlobal()) {
            DBPPlatform platform = DBWorkbench.getPlatform();
            if (platform instanceof DBPPlatformDesktop) {
                ((DBPPlatformDesktop)platform).getWorkspace().getEclipseWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            }
            new EventProcessingJob().schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object;
        DBPPlatform platform;
        if (this.isGlobal() && (platform = DBWorkbench.getPlatform()) instanceof DBPPlatformDesktop) {
            ((DBPPlatformDesktop)platform).getWorkspace().getEclipseWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (this.root != null) {
            this.root.dispose(false);
            object = this.nodeMap;
            synchronized (object) {
                this.nodeMap.clear();
            }
            this.root = null;
        }
        object = this.listeners;
        synchronized (object) {
            if (!this.listeners.isEmpty()) {
                for (INavigatorListener listener : this.listeners) {
                    log.warn("Listener '" + listener + "' is not unregistered from DBM model");
                }
            }
            this.listeners.clear();
            this.listenersCopy = null;
        }
    }

    public DBNRoot getRoot() {
        return this.root;
    }

    @Nullable
    public DBNDatabaseNode findNode(DBSObject object) {
        if (object instanceof DBNDatabaseNode) {
            return (DBNDatabaseNode)((Object)object);
        }
        return this.getNodeByObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DBNDatabaseNode getNodeByObject(DBSObject object) {
        Object obj;
        if (object instanceof DBNDatabaseNode) {
            return (DBNDatabaseNode)((Object)object);
        }
        object = DBUtils.getPublicObjectContainer(object);
        Map<DBSObject, Object> map = this.nodeMap;
        synchronized (map) {
            obj = this.nodeMap.get(object);
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof DBNDatabaseNode) {
            return (DBNDatabaseNode)obj;
        }
        if (obj instanceof List) {
            List nodeList = (List)obj;
            if (nodeList.isEmpty()) {
                return null;
            }
            if (nodeList.size() > 1) {
                for (DBNDatabaseNode node : nodeList) {
                    if (!(node instanceof DBNDatabaseItem) || ((DBNDatabaseItem)node).getMeta().isVirtual()) continue;
                    return node;
                }
            }
            return (DBNDatabaseNode)nodeList.get(0);
        }
        throw new IllegalStateException();
    }

    @Nullable
    public DBNDatabaseNode getNodeByObject(DBRProgressMonitor monitor, DBSObject object, boolean addFiltered) {
        if (object instanceof DBSEntity) {
            try {
                object = DBVUtils.getRealEntity(monitor, (DBSEntity)object);
            }
            catch (DBException e) {
                log.debug("Error dereferencing virtual entity", e);
            }
        }
        if (object == null) {
            return null;
        }
        DBNDatabaseNode node = this.getNodeByObject(object);
        if (node != null) {
            return node;
        }
        DBSObject[] path = DBUtils.getObjectPath(object, true);
        int i = 0;
        while (i < path.length - 1) {
            DBSObject item = path[i];
            DBSObject nextItem = path[i + 1];
            node = this.getNodeByObject(item);
            if (node == null) {
                return null;
            }
            try {
                this.cacheNodeChildren(monitor, node, nextItem, addFiltered);
            }
            catch (DBException e) {
                log.error(e.getMessage());
                return null;
            }
            ++i;
        }
        return this.getNodeByObject(object);
    }

    @NotNull
    private NodePath getNodePath(@NotNull String path) {
        DBNNode.NodePathType nodeType = DBNNode.NodePathType.other;
        DBNNode.NodePathType[] nodePathTypeArray = DBNNode.NodePathType.values();
        int n = nodePathTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode.NodePathType type = nodePathTypeArray[n2];
            String prefix = type.getPrefix();
            if (path.startsWith(prefix)) {
                path = path.substring(prefix.length());
                nodeType = type;
                break;
            }
            ++n2;
        }
        return new NodePath(nodeType, CommonUtils.splitString((String)path, (char)'/'));
    }

    @Nullable
    public DBNDataSource getDataSourceByPath(DBPProject project, String path) {
        DBNDataSource dataSource;
        String dsId = this.getNodePath(path).first();
        DBNProject projectNode = this.getRoot().getProjectNode(project);
        if (projectNode != null && (dataSource = projectNode.getDatabases().getDataSource(dsId)) != null) {
            return dataSource;
        }
        return null;
    }

    @Nullable
    public DBNNode getNodeByPath(@NotNull DBRProgressMonitor monitor, @NotNull String path) throws DBException {
        block15: {
            NodePath nodePath;
            block14: {
                DBNDataSource curNode;
                DBNProject projectNode;
                nodePath = this.getNodePath(path);
                if (nodePath.type != DBNNode.NodePathType.database) break block14;
                boolean hasLazyProjects = false;
                DBNProject[] dBNProjectArray = this.getRoot().getProjects();
                int n = dBNProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    projectNode = dBNProjectArray[n2];
                    if (!projectNode.getProject().isRegistryLoaded()) {
                        hasLazyProjects = true;
                    } else {
                        curNode = projectNode.getDatabases().getDataSource(nodePath.first());
                        if (curNode != null) {
                            return this.findNodeByPath(monitor, nodePath, curNode, 1);
                        }
                    }
                    ++n2;
                }
                if (!hasLazyProjects) break block15;
                dBNProjectArray = this.getRoot().getProjects();
                n = dBNProjectArray.length;
                n2 = 0;
                while (n2 < n) {
                    projectNode = dBNProjectArray[n2];
                    if (!projectNode.getProject().isRegistryLoaded() && (curNode = projectNode.getDatabases().getDataSource(nodePath.first())) != null) {
                        return this.findNodeByPath(monitor, nodePath, curNode, 1);
                    }
                    ++n2;
                }
                break block15;
            }
            if (nodePath.type == DBNNode.NodePathType.ext) {
                DBNNode node = this.findNodeByPath(monitor, nodePath, this.root, 0);
                if (node != null) {
                    return node;
                }
                Object[] projects = this.root.getProjects();
                if (ArrayUtils.isEmpty((Object[])projects)) {
                    throw new DBException("No projects in workspace");
                }
                String projectId = nodePath.first();
                Object parentProjectNode = projectId == null ? null : (DBNProject)Arrays.stream(projects).filter(dbnProject -> dbnProject.getProject().getId().equals(projectId)).findFirst().orElse(null);
                int firstItem = 0;
                if (parentProjectNode == null) {
                    parentProjectNode = projects[0];
                } else {
                    firstItem = 1;
                }
                return this.findNodeByPath(monitor, nodePath, (DBNNode)parentProjectNode, firstItem);
            }
            if (nodePath.type == DBNNode.NodePathType.other) {
                return this.findNodeByPath(monitor, nodePath, this.root, 0);
            }
            DBNProject[] dBNProjectArray = this.getRoot().getProjects();
            int n = dBNProjectArray.length;
            int n3 = 0;
            while (n3 < n) {
                DBNProject projectNode = dBNProjectArray[n3];
                if (projectNode.getName().equals(nodePath.first())) {
                    return this.findNodeByPath(monitor, nodePath, nodePath.type == DBNNode.NodePathType.folder ? projectNode.getDatabases() : projectNode, 1);
                }
                ++n3;
            }
        }
        return null;
    }

    @Nullable
    public DBNNode getNodeByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull String path) throws DBException {
        DBNProject projectNode = this.getRoot().getProjectNode(project);
        if (projectNode == null) {
            log.debug("Project node not found");
            return null;
        }
        NodePath nodePath = this.getNodePath(path);
        DBNNode curNode = switch (nodePath.type) {
            case DBNNode.NodePathType.database -> projectNode.getDatabases().getDataSource(nodePath.first());
            case DBNNode.NodePathType.folder -> projectNode.getDatabases();
            default -> projectNode;
        };
        if (curNode == null) {
            return null;
        }
        return this.findNodeByPath(monitor, nodePath, curNode, 1);
    }

    public DBNResource getNodeByResource(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        DBNProject projectNode = this.getRoot().getProjectNode(project);
        if (projectNode == null) {
            return null;
        }
        ArrayList<IResource> path = new ArrayList<IResource>();
        IResource parent = resource;
        while (parent != null && parent != project) {
            path.add(0, parent);
            parent = parent.getParent();
        }
        DBNResource curResNode = projectNode;
        for (IResource res : path) {
            if ((curResNode = curResNode.getChild(res)) != null) continue;
            return null;
        }
        return curResNode;
    }

    private DBNNode findNodeByPath(DBRProgressMonitor monitor, NodePath nodePath, DBNNode curNode, int firstItem) throws DBException {
        List<String> pathItems = nodePath.pathItems;
        int i = firstItem;
        int itemsSize = pathItems.size();
        while (i < itemsSize) {
            String item = pathItems.get(i).replace(SLASH_ESCAPE_TOKEN, "/");
            if (nodePath.type == DBNNode.NodePathType.ext && curNode instanceof DBNProject var9_9) {
                pn.getExtraNode(DBNFileSystems.class);
            }
            Object[] children = curNode.getChildren(monitor);
            DBNNode nextChild = null;
            if (children != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    DBNNode child = objectArray[n2];
                    if (this.nodeMatchesPath(nodePath, child, item)) {
                        nextChild = child;
                    }
                    if (nextChild != null) {
                        if (i >= itemsSize - 1) break;
                        if ((nextChild = this.findNodeByPath(monitor, nodePath, nextChild, i + 1)) != null) {
                            return nextChild;
                        }
                    }
                    ++n2;
                }
            }
            if (nextChild == null) {
                log.debug("Node '" + item + "' not found in parent node '" + curNode.getNodeItemPath() + "'." + "\nAllowed children: " + Arrays.toString(children));
            }
            if (nextChild != null) {
                curNode = nextChild;
            }
            ++i;
        }
        if (!pathItems.isEmpty() && !this.nodeMatchesPath(nodePath, curNode, pathItems.get(pathItems.size() - 1))) {
            return null;
        }
        return curNode;
    }

    private boolean nodeMatchesPath(@NotNull NodePath path, @NotNull DBNNode child, @NotNull String item) {
        String idOrType;
        DBXTreeFolder meta;
        if (path.type == DBNNode.NodePathType.resource) {
            return child instanceof DBNProject && ((DBNProject)child).getProject().getId().equals(item) || child instanceof DBNResource && ((DBNResource)child).getResource().getName().equals(item) || child instanceof DBNProjectDatabases && child.getName().equals(item);
        }
        if (path.type == DBNNode.NodePathType.folder) {
            return child instanceof DBNLocalFolder && child.getName().equals(item);
        }
        if (child instanceof DBNDataSource) {
            return ((DBNDataSource)child).getDataSourceContainer().getId().equals(item);
        }
        if (child instanceof DBNDatabaseFolder && (meta = ((DBNDatabaseFolder)child).getMeta()) != null && !CommonUtils.isEmpty((String)(idOrType = meta.getIdOrType())) && idOrType.equals(item)) {
            return true;
        }
        return child.getName().equals(item);
    }

    private boolean cacheNodeChildren(DBRProgressMonitor monitor, DBNDatabaseNode node, DBSObject objectToCache, boolean addFiltered) throws DBException {
        Object[] children = node.getChildren(monitor);
        boolean cached = false;
        if (!ArrayUtils.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof DBNDatabaseFolder) {
                    Class<? extends DBSObject> itemsClass = ((DBNDatabaseFolder)child).getChildrenClass();
                    if (itemsClass != null && itemsClass.isAssignableFrom(objectToCache.getClass()) && (cached = this.cacheNodeChildren(monitor, (DBNDatabaseNode)child, objectToCache, addFiltered))) {
                        break;
                    }
                } else if (child.getObject() == objectToCache) {
                    cached = true;
                    break;
                }
                ++n2;
            }
        }
        if (!cached && addFiltered && node.isFiltered()) {
            node.addChildItem(objectToCache);
            return true;
        }
        return false;
    }

    @Nullable
    public DBNDatabaseNode getParentNode(DBSObject object) {
        DBNDatabaseNode node = this.getNodeByObject(object);
        if (node != null) {
            if (node.getParentNode() instanceof DBNDatabaseNode) {
                return (DBNDatabaseNode)node.getParentNode();
            }
            log.error("Object's " + object.getName() + "' parent node is not a database node: " + node.getParentNode());
            return null;
        }
        DBSObject[] path = DBUtils.getObjectPath(object, false);
        int i = 0;
        while (i < path.length) {
            DBSObject item = path[i];
            node = this.getNodeByObject(item);
            if (node == null) {
                return null;
            }
            Object[] children = node.getChildNodes();
            if (ArrayUtils.isEmpty((Object[])children)) {
                return null;
            }
            if (item == DBUtils.getPublicObjectContainer(object.getParentObject())) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<? extends DBSObject> itemsClass;
                    Object child = objectArray[n2];
                    if (child instanceof DBNDatabaseFolder && (itemsClass = ((DBNDatabaseFolder)child).getChildrenClass()) != null && itemsClass.isAssignableFrom(object.getClass())) {
                        return child;
                    }
                    ++n2;
                }
                return node;
            }
            ++i;
        }
        return null;
    }

    void addNode(DBNDatabaseNode node) {
        this.addNode(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNode(DBNDatabaseNode node, boolean reflect) {
        Map<DBSObject, Object> map = this.nodeMap;
        synchronized (map) {
            Object obj = this.nodeMap.get(node.getObject());
            if (obj == null) {
                this.nodeMap.put(node.getObject(), node);
            } else if (obj instanceof DBNNode) {
                ArrayList<DBNNode> nodeList = new ArrayList<DBNNode>(2);
                nodeList.add((DBNNode)obj);
                nodeList.add(node);
                this.nodeMap.put(node.getObject(), nodeList);
            } else if (obj instanceof List) {
                List nodeList = (List)obj;
                nodeList.add(node);
            }
        }
        if (reflect) {
            this.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, DBNEvent.NodeChange.LOAD, node));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNode(DBNDatabaseNode node, boolean reflect) {
        boolean badNode = false;
        Map<DBSObject, Object> map = this.nodeMap;
        synchronized (map) {
            Object obj = this.nodeMap.get(node.getObject());
            if (obj == null) {
                badNode = true;
            } else if (obj instanceof DBNNode) {
                if (this.nodeMap.remove(node.getObject()) != node) {
                    badNode = true;
                }
            } else if (obj instanceof List) {
                List nodeList = (List)obj;
                if (!nodeList.remove(node)) {
                    badNode = true;
                }
                if (nodeList.isEmpty()) {
                    this.nodeMap.remove(node.getObject());
                }
            }
        }
        if (badNode) {
            log.warn("Remove unregistered meta node object " + node.getNodeName());
        } else if (reflect) {
            this.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, DBNEvent.NodeChange.UNLOAD, node));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(INavigatorListener listener) {
        List<INavigatorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                log.warn("Listener " + listener + " already registered in model");
            } else {
                this.listeners.add(listener);
            }
            this.listenersCopy = this.listeners.toArray(new INavigatorListener[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(INavigatorListener listener) {
        List<INavigatorListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.remove(listener)) {
                log.warn("Listener " + listener + " wasn't registered in model");
            }
            this.listenersCopy = this.listeners.toArray(new INavigatorListener[0]);
        }
    }

    public void fireNodeUpdate(Object source, DBNNode node, DBNEvent.NodeChange nodeChange) {
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, nodeChange, node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeEvent(DBNEvent event) {
        if (!this.isGlobal() || this.platform.isShuttingDown()) {
            return;
        }
        List<DBNEvent> list = this.eventCache;
        synchronized (list) {
            this.eventCache.add(event);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                if (childDelta.getResource() instanceof IProject) {
                    IProject project = (IProject)childDelta.getResource();
                    DBNProject projectNode = this.getRoot().getProjectNode(project);
                    if (projectNode == null) {
                        if (childDelta.getKind() == 1) {
                            projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(project);
                            if (projectMeta == null) {
                                log.error("Can't find project '" + project.getName() + "' metadata");
                            } else {
                                this.getRoot().addProject(projectMeta, true);
                            }
                        } else if (childDelta.getKind() != 2) {
                            log.error("Project '" + childDelta.getResource().getName() + "' not found in navigator");
                        }
                    } else if (childDelta.getKind() == 2) {
                        projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(project);
                        if (projectMeta == null) {
                            log.error("Can't find project '" + project.getName() + "' metadata");
                        } else {
                            this.getRoot().removeProject(projectMeta);
                        }
                    } else {
                        projectNode.handleResourceChange(childDelta);
                    }
                }
                ++n2;
            }
        }
    }

    public static synchronized DBPImage getStateOverlayImage(DBPImage image, DBSObjectState state) {
        if (state == null) {
            return image;
        }
        DBPImage overlayImage = state.getOverlayImage();
        if (overlayImage == null) {
            return image;
        }
        if (image instanceof DBIconComposite) {
            ((DBIconComposite)image).setBottomRight(overlayImage);
            return image;
        }
        return new DBIconComposite(image, false, null, null, null, overlayImage);
    }

    public static void updateConfigAndRefreshDatabases(DBNNode node) {
        DBNNode parentNode = node;
        while (parentNode != null) {
            if (parentNode instanceof DBNProjectDatabases) {
                DBNProjectDatabases projectDatabases = (DBNProjectDatabases)parentNode;
                projectDatabases.getDataSourceRegistry().flushConfig();
                projectDatabases.refreshChildren();
                break;
            }
            parentNode = parentNode.getParentNode();
        }
    }

    public void ensureProjectLoaded(DBPProject project) {
        DBNProject projectNode = this.getRoot().getProjectNode(project);
        if (projectNode != null) {
            projectNode.getDatabases();
        }
    }

    public void addFilter(Function<DBNNode, Boolean> filter) {
        this.nodeFilters.add(filter);
    }

    boolean isNodeVisible(DBNNode node) {
        if (!this.nodeFilters.isEmpty()) {
            for (Function<DBNNode, Boolean> f : this.nodeFilters) {
                if (f.apply(node).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static void disposeNode(DBNNode node, boolean reflect) {
        node.dispose(reflect);
    }

    private class EventProcessingJob
    extends Job {
        EventProcessingJob() {
            super("Navigator notifier");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Thread.currentThread().setName("Database navigator events processor");
            while (!DBNModel.this.platform.isShuttingDown()) {
                DBNEvent[] realEvents;
                INavigatorListener[] realListeners;
                RuntimeUtils.pause(100);
                List<INavigatorListener> list = DBNModel.this.listeners;
                synchronized (list) {
                    realListeners = DBNModel.this.listenersCopy;
                }
                if (realListeners == null || realListeners.length == 0) continue;
                List<DBNEvent> list2 = DBNModel.this.eventCache;
                synchronized (list2) {
                    if (DBNModel.this.eventCache.isEmpty()) {
                        continue;
                    }
                    realEvents = DBNModel.this.eventCache.toArray(new DBNEvent[0]);
                    DBNModel.this.eventCache.clear();
                }
                try {
                    DBWorkbench.getPlatformUI().executeWithProgress(() -> {
                        int i = 0;
                        while (i < realEvents.length) {
                            INavigatorListener[] iNavigatorListenerArray = DBNModel.this.listenersCopy;
                            int n = DBNModel.this.listenersCopy.length;
                            int n2 = 0;
                            while (n2 < n) {
                                INavigatorListener listener = iNavigatorListenerArray[n2];
                                listener.nodeChanged(realEvents[i]);
                                ++n2;
                            }
                            ++i;
                        }
                    });
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private static class NodePath {
        DBNNode.NodePathType type;
        List<String> pathItems;

        NodePath(DBNNode.NodePathType type, List<String> pathItems) {
            this.type = type;
            this.pathItems = pathItems;
        }

        public String first() {
            return this.pathItems.isEmpty() ? null : this.pathItems.get(0);
        }

        public String toString() {
            return String.valueOf(this.type.getPrefix()) + this.pathItems.toString();
        }
    }
}

