/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.sf.jsqlparser.expression.NextValExpression;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerConstants;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSourceInfo;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDialect;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExecutionContext;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerLogin;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerLoginPasswordManager;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerStructureAssistant;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.session.SQLServerSessionManager;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProviderExt;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerTop;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstanceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class SQLServerDataSource
extends JDBCDataSource
implements DBSInstanceContainer,
DBPObjectStatisticsCollector,
DBPAdaptable,
DBCQueryTransformProviderExt {
    private static final Log log = Log.getLog(SQLServerDataSource.class);
    private final SystemDataTypeCache dataTypeCache = new SystemDataTypeCache();
    private final DatabaseCache databaseCache = new DatabaseCache();
    private final ServerLoginCache serverLoginCache = new ServerLoginCache();
    private boolean supportsColumnProperty;
    private String serverVersion;
    private volatile Boolean supportsIsExternalColumn;
    private volatile transient boolean hasStatistics;
    private boolean isBabelfish = SQLServerUtils.isDriverBabelfish(this.getContainer().getDriver());
    private boolean isSynapseDatabase;

    public SQLServerDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new SQLServerDialect());
    }

    public boolean supportsColumnProperty() {
        return this.supportsColumnProperty;
    }

    @Deprecated(forRemoval=true)
    public boolean supportsExternalTables() {
        if (this.supportsIsExternalColumn != null) {
            return this.supportsIsExternalColumn;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBPDataSource)this, (String)"Determine external tables availability");){
                return this.supportsExternalTables(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBCException dBCException) {
            return false;
        }
    }

    public boolean supportsExternalTables(JDBCSession session) {
        if (this.supportsIsExternalColumn != null) {
            return this.supportsIsExternalColumn;
        }
        if (this.isBabelfish) {
            this.supportsIsExternalColumn = false;
            return false;
        }
        try {
            JDBCUtils.queryString((Connection)session, (String)"SELECT TOP 1 is_external from sys.tables where 1<>1", (Object[])new Object[0]);
            this.supportsIsExternalColumn = true;
        }
        catch (Exception exception) {
            this.supportsIsExternalColumn = false;
        }
        return this.supportsIsExternalColumn;
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        SQLServerDataSourceInfo info = new SQLServerDataSourceInfo(this, metaData);
        if (this.isDataWarehouseServer(monitor)) {
            info.setSupportsResultSetScroll(false);
        }
        return info;
    }

    public boolean isDataWarehouseServer(DBRProgressMonitor monitor) {
        return this.getServerVersion(monitor).contains(SQLServerConstants.SQL_DW_SERVER_LABEL);
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean supportsTriggers() {
        return !this.isBabelfish && !this.isSynapseDatabase;
    }

    public boolean supportsSynonyms() {
        return !this.isBabelfish;
    }

    public boolean supportsSequences() {
        return !this.isBabelfish && !this.isSynapseDatabase;
    }

    public boolean isSynapseDatabase() {
        return this.isSynapseDatabase;
    }

    private String getServerVersion(DBRProgressMonitor monitor) {
        if (this.serverVersion == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read server version");){
                    this.serverVersion = JDBCUtils.queryString((Connection)session, (String)"SELECT @@VERSION", (Object[])new Object[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.debug((Object)("Error reading SQL Server version: " + e.getMessage()));
                this.serverVersion = "";
            }
        }
        return this.serverVersion;
    }

    public DatabaseCache getDatabaseCache() {
        return this.databaseCache;
    }

    @Association
    public List<SQLServerLogin> getLogins(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.serverLoginCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public SQLServerLogin getLogin(@NotNull DBRProgressMonitor monitor, @NotNull String loginName) throws DBException {
        return (SQLServerLogin)this.serverLoginCache.getObject(monitor, (DBSObject)this, loginName);
    }

    public ServerLoginCache getServerLoginCache() {
        return this.serverLoginCache;
    }

    protected Properties getAllConnectionProperties(@NotNull DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        boolean trustCertificate;
        Properties properties = super.getAllConnectionProperties(monitor, context, purpose, connectionInfo);
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            properties.put(SQLServerUtils.isDriverJtds(this.getContainer().getDriver()) ? "APPNAME" : "applicationName", CommonUtils.truncateString((String)DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose), (int)64));
        }
        if (SQLServerUtils.isDriverSqlServer(this.getContainer().getDriver()) && (trustCertificate = CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("sslTrustServerCertificate"), (boolean)false))) {
            properties.put("trustServerCertificate", Boolean.TRUE.toString());
        }
        this.fillConnectionProperties(connectionInfo, properties);
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("mssql_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            this.initSSL(monitor, properties, sslConfig);
        }
        return properties;
    }

    private void initSSL(DBRProgressMonitor monitor, Properties properties, DBWHandlerConfiguration sslConfig) throws DBCException {
        monitor.subTask("Install SSL certificates");
        try {
            String keystoreHostnameProp;
            String keystorePasswordProp;
            String keystoreFileProp;
            properties.put("encrypt", "true");
            if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
                byte[] trustStoreData = SSLHandlerTrustStoreImpl.readTrustStoreData((DBWHandlerConfiguration)sslConfig, (String)"ssl.keystore");
                keystoreFileProp = trustStoreData != null && trustStoreData.length != 0 ? this.saveTrustStoreToFile(trustStoreData) : null;
                keystorePasswordProp = sslConfig.getSecureProperty("ssl.keystore.password");
            } else if (CommonUtils.isEmpty((String)sslConfig.getStringProperty("ssl.method"))) {
                keystoreFileProp = sslConfig.getStringProperty("sslKeyStore");
                keystorePasswordProp = sslConfig.getStringProperty("sslKeyStorePassword");
            } else {
                keystoreFileProp = sslConfig.getStringProperty("ssl.keystore");
                keystorePasswordProp = sslConfig.getPassword();
            }
            if (!CommonUtils.isEmpty((String)keystoreFileProp)) {
                properties.put("trustStore", keystoreFileProp);
            }
            if (!CommonUtils.isEmpty((String)keystorePasswordProp)) {
                properties.put("trustStorePassword", keystorePasswordProp);
            }
            if (!CommonUtils.isEmpty((String)(keystoreHostnameProp = sslConfig.getStringProperty("sslKeyStoreHostname")))) {
                properties.put("hostNameInCertificate", keystoreHostnameProp);
            }
        }
        catch (Exception e) {
            throw new DBCException("Error initializing SSL trust store", (Throwable)e);
        }
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new SQLServerExecutionContext(instance, type);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        super.initializeContextState(monitor, context, initFrom);
        if (initFrom != null) {
            if (!this.isDataWarehouseServer(monitor)) {
                SQLServerSchema defaultSchema;
                SQLServerExecutionContext ssContext = (SQLServerExecutionContext)initFrom;
                SQLServerDatabase defaultObject = ssContext.getDefaultCatalog();
                if (defaultObject != null) {
                    ((SQLServerExecutionContext)context).setCurrentDatabase(monitor, defaultObject);
                }
                if ((defaultSchema = ssContext.getDefaultSchema()) != null && !this.isDataWarehouseServer(monitor)) {
                    ((SQLServerExecutionContext)context).setDefaultSchema(monitor, defaultSchema);
                }
            }
        } else {
            ((SQLServerExecutionContext)context).refreshDefaults(monitor, true);
        }
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.limit-affects-dml": {
                return true;
            }
            case "datasource.max-string-type-length": {
                return 8000;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        this.databaseCache.getAllObjects(monitor, (DBSObject)this);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load data source meta info");){
                try {
                    JDBCUtils.queryString((Connection)session, (String)"SELECT COLUMNPROPERTY(0, NULL, NULL)", (Object[])new Object[0]);
                    this.supportsColumnProperty = true;
                }
                catch (Exception exception) {
                    this.supportsColumnProperty = false;
                }
                try {
                    String result = JDBCUtils.queryString((Connection)session, (String)"SELECT SERVERPROPERTY('EngineEdition')", (Object[])new Object[0]);
                    if ("6".equals(result) || "11".equals(result)) {
                        this.isSynapseDatabase = true;
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)"Can't read Database Engine edition info", (Throwable)e);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error during connection initialization", e);
        }
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        return this.getLocalDataType(valueType).getDataKind();
    }

    public List<SQLServerDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    SQLServerDataType getSystemDataType(int systemTypeId) {
        for (SQLServerDataType dt : this.dataTypeCache.getCachedObjects()) {
            if (dt.getObjectId() != (long)systemTypeId) continue;
            return dt;
        }
        if (systemTypeId != 243) {
            log.debug((Object)("System data type " + systemTypeId + " not found"));
        }
        SQLServerDataType sdt = new SQLServerDataType((DBSObject)this, String.valueOf(systemTypeId), systemTypeId, DBPDataKind.OBJECT, 1111);
        this.dataTypeCache.cacheObject(sdt);
        return sdt;
    }

    public SQLServerDataType getLocalDataType(String typeName) {
        return (SQLServerDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    public SQLServerDataType getLocalDataType(int typeID) {
        DBSDataType dt = super.getLocalDataType(typeID);
        if (dt == null) {
            log.debug((Object)("System data type " + typeID + " not found"));
        }
        return (SQLServerDataType)dt;
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return "bit";
            }
            case NUMERIC: {
                return "int";
            }
            case STRING: {
                return "varchar";
            }
            case DATETIME: {
                return "datetime";
            }
            case BINARY: 
            case CONTENT: {
                return "varbinary";
            }
            case ROWID: {
                return "uniqueidentifier";
            }
        }
        return super.getDefaultDataTypeName(dataKind);
    }

    protected boolean isShowAllSchemas() {
        return CommonUtils.toBoolean((Object)this.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-show-all-schemas@"));
    }

    @Association
    public Collection<SQLServerDatabase> getDatabases(DBRProgressMonitor monitor) throws DBException {
        return this.databaseCache.getAllObjects(monitor, (DBSObject)this);
    }

    public SQLServerDatabase getDatabase(DBRProgressMonitor monitor, String name) throws DBException {
        return (SQLServerDatabase)this.databaseCache.getObject(monitor, (DBSObject)this, name);
    }

    public SQLServerDatabase getDatabase(DBRProgressMonitor monitor, long dbId) throws DBException {
        for (SQLServerDatabase db : this.databaseCache.getAllObjects(monitor, (DBSObject)this)) {
            if (db.getDatabaseId() != dbId) continue;
            return db;
        }
        return null;
    }

    public SQLServerDatabase getDatabase(String name) {
        return (SQLServerDatabase)this.databaseCache.getCachedObject(name);
    }

    public SQLServerDatabase getDefaultDatabase(@NotNull DBRProgressMonitor monitor) {
        return ((SQLServerExecutionContext)this.getDefaultInstance().getDefaultContext(monitor, true)).getDefaultCatalog();
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.databaseCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.databaseCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return SQLServerDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.databaseCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.databaseCache.clearCache();
        this.serverLoginCache.clearCache();
        this.hasStatistics = false;
        return super.refreshObject(monitor);
    }

    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerTop();
        }
        return super.createQueryTransformer(type);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new SQLServerStructureAssistant(this));
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new SQLServerSessionManager(this));
        }
        if (adapter == DBAUserPasswordManager.class) {
            return adapter.cast(new SQLServerLoginPasswordManager(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(DBRProgressMonitor monitor, DBCExecutionContext context, String query, Throwable error) {
        Throwable rootCause = GeneralUtils.getRootCause((Throwable)error);
        if (rootCause != null && "com.microsoft.sqlserver.jdbc.SQLServerException".equals(rootCause.getClass().getName())) {
            try {
                Object serverErrorLine;
                Object serverError = rootCause.getClass().getMethod("getSQLServerError", new Class[0]).invoke((Object)rootCause, new Object[0]);
                if (serverError != null && (serverErrorLine = BeanUtils.readObjectProperty((Object)serverError, (String)"lineNumber")) instanceof Number) {
                    DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                    pos.line = ((Number)serverErrorLine).intValue() - 1;
                    return new DBPErrorAssistant.ErrorPosition[]{pos};
                }
            }
            catch (Throwable throwable) {}
        }
        return super.getErrorPosition(monitor, context, query, error);
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        if (SQLServerUtils.isDriverAzure(this.getContainer().getDriver()) || SQLServerUtils.isDriverBabelfish(this.getContainer().getDriver()) || this.isDataWarehouseServer(monitor)) {
            this.hasStatistics = true;
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load schema statistics");){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCStatement dbStat = session.createStatement();){
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery("SELECT database_id, SUM(size)\nFROM sys.master_files WITH(NOWAIT)\nGROUP BY database_id");){
                            while (dbResult.next()) {
                                long dbId = JDBCUtils.safeGetLong((ResultSet)dbResult, (int)1);
                                long bytes = dbResult.getLong(2) * 8L * 1024L;
                                SQLServerDatabase database = this.getDatabase(monitor, dbId);
                                if (database == null) continue;
                                database.setDatabaseTotalSize(bytes);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading database statistics", (Throwable)e);
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    public boolean isForceTransform(DBCSession session, SQLQuery sqlQuery) {
        try {
            SQLServerTableBase table = SQLServerUtils.getTableFromQuery(session, sqlQuery, this);
            return table != null && table.isClustered(session.getProgressMonitor());
        }
        catch (SQLException | DBException e) {
            log.debug((Object)"Table not found. ", e);
            return false;
        }
    }

    public boolean isLimitApplicableTo(SQLQuery query) {
        boolean hasNextValExpr = false;
        try {
            PlainSelect plainSelect;
            SelectBody selectBody;
            Statement statement = SQLSemanticProcessor.parseQuery((SQLDialect)this.sqlDialect, (String)query.getText());
            if (statement instanceof Select && (selectBody = ((Select)statement).getSelectBody()) instanceof PlainSelect && (plainSelect = (PlainSelect)selectBody).getFromItem() == null) {
                hasNextValExpr = plainSelect.getSelectItems().stream().anyMatch(item -> item instanceof SelectExpressionItem && ((SelectExpressionItem)item).getExpression() instanceof NextValExpression);
            }
        }
        catch (DBCException e) {
            log.error((Object)("Can't parse query " + query.getText()), (Throwable)e);
        }
        return !hasNextValExpr;
    }

    static class DatabaseCache
    extends JDBCObjectCache<SQLServerDataSource, SQLServerDatabase> {
        DatabaseCache() {
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerDataSource owner) throws SQLException {
            JDBCPreparedStatement dbStat;
            boolean useCurrentDatabaseName;
            StringBuilder sql = new StringBuilder("SELECT db.* FROM sys.databases db");
            DBPDataSourceContainer container = owner.getContainer();
            DBPConnectionConfiguration configuration = container.getConnectionConfiguration();
            String property = configuration.getProviderProperty("show-all-databases-azure");
            boolean showSpecifiedDatabase = property != null && !CommonUtils.getBoolean((String)property) || property == null && (owner.isBabelfish || SQLServerUtils.isDriverAzure(owner.getContainer().getDriver()));
            String databaseName = configuration.getDatabaseName();
            boolean bl = useCurrentDatabaseName = showSpecifiedDatabase && CommonUtils.isEmpty((String)databaseName);
            if (useCurrentDatabaseName) {
                sql.append("\nWHERE db.name = db_name()");
            } else if (showSpecifiedDatabase) {
                sql.append("\nWHERE db.name = ?");
            }
            if (!showSpecifiedDatabase) {
                DBSObjectFilter databaseFilters = container.getObjectFilter(SQLServerDatabase.class, null, false);
                if (databaseFilters != null && databaseFilters.isEnabled()) {
                    JDBCUtils.appendFilterClause((StringBuilder)sql, (DBSObjectFilter)databaseFilters, (String)"name", (boolean)true, (DBPDataSource)owner);
                }
                sql.append("\nORDER BY db.name");
                dbStat = session.prepareStatement(sql.toString());
                if (databaseFilters != null) {
                    JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)databaseFilters);
                }
            } else {
                dbStat = session.prepareStatement(sql.toString());
                if (!useCurrentDatabaseName) {
                    dbStat.setString(1, databaseName);
                }
            }
            return dbStat;
        }

        protected SQLServerDatabase fetchObject(@NotNull JDBCSession session, @NotNull SQLServerDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String databaseName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"name");
            if (CommonUtils.isEmpty((String)databaseName)) {
                log.debug((Object)"Empty database name fetched");
                return null;
            }
            return new SQLServerDatabase(session, owner, resultSet, databaseName);
        }
    }

    private class ServerLoginCache
    extends JDBCObjectCache<SQLServerDataSource, SQLServerLogin> {
        private ServerLoginCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerDataSource dataSource) throws SQLException {
            return session.prepareStatement("SELECT * FROM sys.server_principals");
        }

        @Nullable
        protected SQLServerLogin fetchObject(@NotNull JDBCSession session, @NotNull SQLServerDataSource dataSource, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String loginName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"name");
            if (CommonUtils.isNotEmpty((String)loginName)) {
                return new SQLServerLogin(dataSource, loginName, resultSet);
            }
            return null;
        }
    }

    private class SystemDataTypeCache
    extends JDBCObjectCache<SQLServerDataSource, SQLServerDataType> {
        private SystemDataTypeCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerDataSource sqlServerDataSource) throws SQLException {
            return session.prepareStatement("SELECT * FROM sys.types WHERE is_user_defined = 0 order by name");
        }

        protected SQLServerDataType fetchObject(@NotNull JDBCSession session, @NotNull SQLServerDataSource dataSource, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerDataType((DBSObject)dataSource, (ResultSet)resultSet);
        }
    }
}

