/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.session.MySQLSession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.utils.CommonUtils;

public class MySQLSessionManager
implements DBAServerSessionManager<MySQLSession>,
DBAServerSessionManagerSQL {
    public static final String PROP_KILL_QUERY = "killQuery";
    public static final String OPTION_HIDE_SLEEPING = "hideSleeping";
    public static final String OPTION_SHOW_PERFORMANCE = "showPerformance";
    private final MySQLDataSource dataSource;

    public MySQLSessionManager(MySQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Loose catch block
     */
    public Collection<MySQLSession> getSessions(DBCSession session, Map<String, Object> options) throws DBException {
        boolean hideSleeping = CommonUtils.getOption(options, (String)OPTION_HIDE_SLEEPING);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(this.generateSessionReadQuery(options));){
                ArrayList<MySQLSession> arrayList;
                JDBCResultSet dbResult;
                Throwable throwable2;
                block22: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbResult = dbStat.executeQuery();
                    ArrayList<MySQLSession> sessions = new ArrayList<MySQLSession>();
                    while (dbResult.next()) {
                        MySQLSession sessionInfo = new MySQLSession((ResultSet)dbResult, options);
                        if (hideSleeping && "Sleep".equals(sessionInfo.getCommand())) continue;
                        sessions.add(sessionInfo);
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block22;
                    dbResult.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(DBCSession session, MySQLSession sessionType, Map<String, Object> options) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(Boolean.TRUE.equals(options.get(PROP_KILL_QUERY)) ? "KILL QUERY " + sessionType.getPid() : "KILL CONNECTION " + sessionType.getPid());){
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    public String generateSessionReadQuery(Map<String, Object> options) {
        if (CommonUtils.toBoolean((Object)options.get(OPTION_SHOW_PERFORMANCE))) {
            return "SELECT\n\tip.*,\n\tsp.statement_latency,\n\tsp.progress,\n\tsp.lock_latency,\n\tsp.rows_examined,\n\tsp.rows_sent,\n\tsp.rows_affected,\n\tsp.tmp_tables,\n\tsp.tmp_disk_tables,\n\tsp.full_scan,\n\tsp.last_statement,\n\tsp.last_statement_latency,\n\tsp.current_memory,\n\tsp.source,\n\tsp.trx_latency,\n\tsp.trx_state,\n\tsp.trx_autocommit,\n\tsp.program_name\nFROM information_schema.PROCESSLIST ip\nLEFT JOIN sys.processlist sp ON\n\tsp.CONN_ID = ip.ID";
        }
        return "SHOW FULL PROCESSLIST";
    }
}

