/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupAllInfo;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceMap;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.nativetool.ExportSettingsExtension;
import org.jkiss.utils.CommonUtils;

public class PostgreBackupAllSettings
extends AbstractImportExportSettings<DBSObject>
implements ExportSettingsExtension<PostgreDatabaseBackupAllInfo> {
    private static final Log log = Log.getLog(PostgreBackupAllSettings.class);
    private static final String PROP_EXPORT_ALL_ENCODING = "pg.export.all.encoding";
    private static final String PROP_EXPORT_ALL_EXPORT_ONLY_METADATA = "pg.export.all.exportOnlyMetadata";
    private static final String PROP_EXPORT_ALL_ONLY_GLOBALS = "pg.export.all.exportOnlyGlobals";
    private static final String PROP_EXPORT_ALL_ONLY_ROLES = "pg.export.all.exportOnlyRoles";
    private static final String PROP_EXPORT_ALL_ONLY_TABLESPACES = "pg.export.all.exportOnlyTablespaces";
    private static final String PROP_EXPORT_ALL_NO_PRIVILEGES = "pg.export.all.noPrivileges";
    private static final String PROP_EXPORT_ALL_NO_OWNER = "pg.export.all.noOwner";
    private static final String PROP_EXPORT_ALL_ADD_ROLES_PASSWORDS = "pg.export.all.addRolesPasswords";
    private static final String PROP_EXPORT_OBJECTS_ALL = "exportObjects.all";
    private static final String PROP_DATASOURCE = "datasource";
    private static final String PROP_DATABASES = "databases";
    private final List<PostgreDatabaseBackupAllInfo> exportObjects = new ArrayList<PostgreDatabaseBackupAllInfo>();
    private String encoding;
    private boolean exportOnlyMetadata;
    private boolean exportOnlyGlobals;
    private boolean exportOnlyRoles;
    private boolean exportOnlyTablespaces;
    private boolean noPrivileges;
    private boolean noOwner;
    private boolean addRolesPasswords;

    @NotNull
    public String getOutputFile(@NotNull PostgreDatabaseBackupAllInfo info) {
        DBSObjectContainer container = this.getContainerObject(info.getDatabases());
        String outputFileName = this.resolveVars((DBSObjectContainer)(container != null ? container : info.getDataSource()), null, null, this.getOutputFilePattern());
        String outputFolder = this.getOutputFolder(info);
        return this.makeOutFilePath(outputFolder, outputFileName);
    }

    @NotNull
    public final List<PostgreDatabaseBackupAllInfo> getExportObjects() {
        return this.exportObjects;
    }

    @NotNull
    public String getOutputFolder(@NotNull PostgreDatabaseBackupAllInfo info) {
        DBSObjectContainer container = this.getContainerObject(info.getDatabases());
        return this.resolveVars((DBSObjectContainer)(container != null ? container : info.getDataSource()), null, null, this.getOutputFolderPattern());
    }

    @Nullable
    private DBSObjectContainer getContainerObject(@Nullable List<PostgreDatabase> databases) {
        Iterator<PostgreDatabase> iterator;
        Iterator<PostgreDatabase> iterator2 = iterator = databases == null ? null : databases.iterator();
        if (iterator != null && iterator.hasNext()) {
            return (DBSObjectContainer)iterator.next();
        }
        return null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isExportOnlyMetadata() {
        return this.exportOnlyMetadata;
    }

    public void setExportOnlyMetadata(boolean exportOnlyMetadata) {
        this.exportOnlyMetadata = exportOnlyMetadata;
    }

    public boolean isExportOnlyGlobals() {
        return this.exportOnlyGlobals;
    }

    public void setExportOnlyGlobals(boolean exportOnlyGlobals) {
        this.exportOnlyGlobals = exportOnlyGlobals;
    }

    public boolean isExportOnlyRoles() {
        return this.exportOnlyRoles;
    }

    public void setExportOnlyRoles(boolean exportOnlyRoles) {
        this.exportOnlyRoles = exportOnlyRoles;
    }

    public boolean isExportOnlyTablespaces() {
        return this.exportOnlyTablespaces;
    }

    public void setExportOnlyTablespaces(boolean exportOnlyTablespaces) {
        this.exportOnlyTablespaces = exportOnlyTablespaces;
    }

    public boolean isNoPrivileges() {
        return this.noPrivileges;
    }

    public void setNoPrivileges(boolean noPrivileges) {
        this.noPrivileges = noPrivileges;
    }

    public boolean isNoOwner() {
        return this.noOwner;
    }

    public void setNoOwner(boolean noOwner) {
        this.noOwner = noOwner;
    }

    public boolean isAddRolesPasswords() {
        return this.addRolesPasswords;
    }

    public void setAddRolesPasswords(boolean addRolesPasswords) {
        this.addRolesPasswords = addRolesPasswords;
    }

    public void fillExportObjectsFromInput() {
        PostgreDataSource dataSource = null;
        ArrayList<PostgreDatabase> databases = new ArrayList<PostgreDatabase>();
        for (DBSObject object : this.getDatabaseObjects()) {
            if (!(object instanceof PostgreDatabase)) continue;
            PostgreDatabase database = (PostgreDatabase)object;
            dataSource = database.getDataSource();
            databases.add(database);
        }
        if (dataSource != null) {
            this.exportObjects.add(new PostgreDatabaseBackupAllInfo(dataSource, databases));
            this.updateDataSourceContainer();
        }
    }

    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) throws DBException {
        List objectList;
        this.encoding = store.getString(PROP_EXPORT_ALL_ENCODING);
        this.exportOnlyMetadata = store.getBoolean(PROP_EXPORT_ALL_EXPORT_ONLY_METADATA);
        this.exportOnlyGlobals = store.getBoolean(PROP_EXPORT_ALL_ONLY_GLOBALS);
        this.exportOnlyRoles = store.getBoolean(PROP_EXPORT_ALL_ONLY_ROLES);
        this.exportOnlyTablespaces = store.getBoolean(PROP_EXPORT_ALL_ONLY_TABLESPACES);
        this.noPrivileges = store.getBoolean(PROP_EXPORT_ALL_NO_PRIVILEGES);
        this.noOwner = store.getBoolean(PROP_EXPORT_ALL_NO_OWNER);
        this.addRolesPasswords = store.getBoolean(PROP_EXPORT_ALL_ADD_ROLES_PASSWORDS);
        super.loadSettings(runnableContext, store);
        if (store instanceof DBPPreferenceMap && !CommonUtils.isEmpty((Collection)(objectList = (List)((DBPPreferenceMap)store).getObject(PROP_EXPORT_OBJECTS_ALL)))) {
            for (Map object : objectList) {
                List databaseNames;
                PostgreDatabaseBackupAllInfo exportInfo;
                String catalogId = CommonUtils.toString(object.get(PROP_DATASOURCE));
                if (CommonUtils.isEmpty((String)catalogId) || (exportInfo = this.loadDatabaseExportInfo(runnableContext, catalogId, databaseNames = (List)object.get(PROP_DATABASES))) == null) continue;
                this.exportObjects.add(exportInfo);
            }
        }
    }

    private PostgreDatabaseBackupAllInfo loadDatabaseExportInfo(@NotNull DBRRunnableContext runnableContext, @NotNull String catalogId, @Nullable List<String> databaseNames) {
        PostgreDatabaseBackupAllInfo[] exportInfo = new PostgreDatabaseBackupAllInfo[1];
        try {
            runnableContext.run(true, true, monitor -> {
                try {
                    PostgreDataSource dataSource = null;
                    DBSObject object = DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)this.getProject(), (String)catalogId);
                    if (object instanceof PostgreDataSource) {
                        dataSource = (PostgreDataSource)object;
                    } else if (object instanceof DBPDataSourceContainer) {
                        dataSource = (PostgreDataSource)object.getDataSource();
                    }
                    if (dataSource == null) {
                        throw new DBException("Datasource " + catalogId + " not found");
                    }
                    ArrayList<PostgreDatabase> databases = new ArrayList<PostgreDatabase>();
                    for (String databaseName : CommonUtils.safeCollection((Collection)databaseNames)) {
                        PostgreDatabase database = dataSource.getDatabase(databaseName);
                        if (database != null) {
                            databases.add(database);
                            continue;
                        }
                        log.debug((Object)("Database '" + databaseName + "' not found in dataSource '" + dataSource.getName() + "'"));
                    }
                    postgreDatabaseBackupAllInfoArray[0] = new PostgreDatabaseBackupAllInfo(dataSource, databases);
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Error loading objects configuration", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        return exportInfo[0];
    }

    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) {
        super.saveSettings(runnableContext, store);
        store.setValue(PROP_EXPORT_ALL_ENCODING, this.encoding);
        store.setValue(PROP_EXPORT_ALL_EXPORT_ONLY_METADATA, this.exportOnlyMetadata);
        store.setValue(PROP_EXPORT_ALL_ONLY_GLOBALS, this.exportOnlyGlobals);
        store.setValue(PROP_EXPORT_ALL_ONLY_ROLES, this.exportOnlyRoles);
        store.setValue(PROP_EXPORT_ALL_ONLY_TABLESPACES, this.exportOnlyTablespaces);
        store.setValue(PROP_EXPORT_ALL_NO_PRIVILEGES, this.noPrivileges);
        store.setValue(PROP_EXPORT_ALL_NO_OWNER, this.noOwner);
        store.setValue(PROP_EXPORT_ALL_ADD_ROLES_PASSWORDS, this.addRolesPasswords);
        if (store instanceof DBPPreferenceMap && !CommonUtils.isEmpty(this.exportObjects)) {
            ArrayList objectList = new ArrayList();
            for (PostgreDatabaseBackupAllInfo object : this.exportObjects) {
                LinkedHashMap<String, Object> objInfo = new LinkedHashMap<String, Object>();
                objInfo.put(PROP_DATASOURCE, DBUtils.getObjectFullId((DBSObject)object.getDataSource()));
                if (!CommonUtils.isEmpty(object.getDatabases())) {
                    ArrayList<String> tableList = new ArrayList<String>();
                    for (PostgreDatabase database : object.getDatabases()) {
                        tableList.add(database.getName());
                    }
                    objInfo.put(PROP_DATABASES, tableList);
                }
                objectList.add(objInfo);
            }
            ((DBPPreferenceMap)store).getPropertyMap().put(PROP_EXPORT_OBJECTS_ALL, objectList);
        }
    }
}

