/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreProcedureManager
extends SQLObjectEditor<PostgreProcedure, PostgreSchema>
implements DBEObjectRenamer<PostgreProcedure> {
    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreProcedure> getObjectsCache(PostgreProcedure object) {
        return ((PostgreSchema)object.getContainer()).getProceduresCache();
    }

    public boolean canCreateObject(Object container) {
        return container instanceof PostgreSchema && ((PostgreSchema)container).getDataSource().getServerType().supportsFunctionCreate();
    }

    public boolean canDeleteObject(PostgreProcedure object) {
        return ((PostgreDataSource)object.getDataSource()).getServerType().supportsFunctionCreate();
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((PostgreProcedure)command.getObject()).getName())) {
            throw new DBException("Function name cannot be empty");
        }
    }

    protected PostgreProcedure createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new PostgreProcedure((PostgreSchema)container);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (PostgreProcedure)command.getObject());
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceProcedureQuery(actionList, (PostgreProcedure)command.getObject());
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        String objectType = ((PostgreProcedure)command.getObject()).getProcedureTypeName();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop function", "DROP " + objectType + " " + ((PostgreProcedure)command.getObject()).getFullQualifiedSignature()));
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actions, PostgreProcedure procedure) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create function", procedure.getBody(), true));
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreProcedure, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        boolean isDDL;
        if (command.getProperty((Object)"description") != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment function", "COMMENT ON " + ((PostgreProcedure)command.getObject()).getProcedureTypeName() + " " + ((PostgreProcedure)command.getObject()).getFullQualifiedSignature() + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((PostgreProcedure)command.getObject()).getDescription())));
        }
        if (isDDL = CommonUtils.getOption(options, (String)"ddl.source")) {
            try {
                PostgreUtils.getObjectGrantPermissionActions(monitor, (PostgrePrivilegeOwner)command.getObject(), actions, options);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreProcedure object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreProcedure procedure = (PostgreProcedure)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename function", "ALTER " + ((PostgreProcedure)command.getObject()).getProcedureTypeName() + " " + DBUtils.getQuotedIdentifier((DBSObject)procedure.getSchema()) + "." + PostgreProcedure.makeOverloadedName(procedure.getSchema(), command.getOldName(), (List<PostgreProcedureParameter>)procedure.getParameters(monitor), true, false, false) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)procedure.getDataSource(), (String)command.getNewName())));
    }
}

