/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.variables;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.registry.SQLQueryParameterRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;

public class RemoveVariablesAction
extends Action {
    protected static final Log log = Log.getLog(RemoveVariablesAction.class);
    private final SQLEditor editor;
    private final List<String> varNames;

    public RemoveVariablesAction(SQLEditor editor, List<String> varNames) {
        super(SQLEditorMessages.action_result_tabs_assign_variable);
        this.editor = editor;
        this.varNames = varNames;
    }

    public void run() {
        if (UIUtils.confirmAction((Shell)this.editor.getSite().getShell(), (String)SQLEditorMessages.action_result_tabs_delete_variables, (String)(String.valueOf(SQLEditorMessages.action_result_tabs_delete_variables_question) + ' ' + this.varNames.toString().replaceAll("^[\\[]|[\\]]$", "") + "?"))) {
            for (String varName : this.varNames) {
                SQLQueryParameterRegistry instance = SQLQueryParameterRegistry.getInstance();
                if (this.editor.getGlobalScriptContext().hasDefaultParameterValue(varName) || instance.getParameter(varName) != null) {
                    this.editor.getGlobalScriptContext().removeDefaultParameterValue(varName);
                    continue;
                }
                this.editor.getGlobalScriptContext().removeVariable(varName);
            }
        }
    }
}

