/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLProblemAnnotation;
import org.jkiss.dbeaver.ui.editors.sql.util.AbstractSQLEditorTextHover;

public class SQLAnnotationHover
extends AbstractSQLEditorTextHover
implements ITextHover,
IAnnotationHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private static final Log log = Log.getLog(SQLAnnotationHover.class);
    private SQLEditorBase editor;

    public SQLAnnotationHover(SQLEditorBase editor) {
        this.setEditor((IEditorPart)editor);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object hoverInfo2 = this.getHoverInfo2(textViewer, hoverRegion);
        return hoverInfo2 == null ? null : hoverInfo2.toString();
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        ISourceViewer sourceViewer = (ISourceViewer)textViewer;
        Iterator ai = sourceViewer.getAnnotationModel().getAnnotationIterator();
        while (ai.hasNext()) {
            Position annoPosition;
            Annotation anno = (Annotation)ai.next();
            if (!this.isSupportedAnnotation(anno) || (annoPosition = sourceViewer.getAnnotationModel().getPosition(anno)) == null || !annoPosition.overlapsWith(hoverRegion.getOffset(), 1)) continue;
            return anno.getText();
        }
        return null;
    }

    private boolean isSupportedAnnotation(Annotation anno) {
        return anno instanceof SpellingAnnotation || anno instanceof SQLProblemAnnotation;
    }

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        IAnnotationModel annotationModel = ((ISourceViewer)textViewer).getAnnotationModel();
        if (annotationModel != null) {
            Iterator ai = annotationModel.getAnnotationIterator();
            while (ai.hasNext()) {
                Position annoPosition;
                Annotation anno = (Annotation)ai.next();
                if (!this.isSupportedAnnotation(anno) || (annoPosition = annotationModel.getPosition(anno)) == null || !annoPosition.overlapsWith(offset, 1)) continue;
                return new Region(annoPosition.getOffset(), annoPosition.getLength());
            }
        }
        return null;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        try {
            int linePosition = sourceViewer.getDocument().getLineOffset(lineNumber);
            int lineLength = sourceViewer.getDocument().getLineLength(lineNumber);
            Iterator ai = sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (ai.hasNext()) {
                Position annoPosition;
                Annotation anno = (Annotation)ai.next();
                if (!this.isSupportedAnnotation(anno) || (annoPosition = sourceViewer.getAnnotationModel().getPosition(anno)) == null || !annoPosition.overlapsWith(linePosition, lineLength)) continue;
                return anno.getText();
            }
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
        }
        return null;
    }

    @Override
    public void setEditor(IEditorPart editor) {
        this.editor = (SQLEditorBase)editor;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return parent -> {
            DefaultInformationControl control = new DefaultInformationControl(parent, false);
            control.setSizeConstraints(60, 10);
            return control;
        };
    }
}

