/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSetOperationModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryValueExpression;

public class SQLQueryRowsNaturalJoinModel
extends SQLQueryRowsSetOperationModel {
    private final SQLQueryValueExpression condition;
    private final List<SQLQuerySymbolEntry> columsToJoin;

    public SQLQueryRowsNaturalJoinModel(@NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, @Nullable SQLQueryValueExpression condition) {
        super(left, right);
        this.condition = condition;
        this.columsToJoin = null;
    }

    public SQLQueryRowsNaturalJoinModel(@NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, @Nullable List<SQLQuerySymbolEntry> columsToJoin) {
        super(left, right);
        this.condition = null;
        this.columsToJoin = columsToJoin;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext left = this.left.propagateContext(context, statistics);
        SQLQueryDataContext right = this.right.propagateContext(context, statistics);
        if (this.columsToJoin != null) {
            for (SQLQuerySymbolEntry column : this.columsToJoin) {
                SQLQuerySymbol symbol = column.getSymbol();
                SQLQuerySymbolDefinition leftColumnDef = left.resolveColumn(column.getName());
                SQLQuerySymbolDefinition rightColumnDef = right.resolveColumn(column.getName());
                if (leftColumnDef != null && rightColumnDef != null) {
                    symbol.setSymbolClass(SQLQuerySymbolClass.COLUMN);
                    symbol.setDefinition(column);
                    continue;
                }
                if (leftColumnDef != null) {
                    statistics.appendError(column, "Column not found to the left of join");
                } else {
                    statistics.appendError(column, "Column not found to the right of join");
                }
                symbol.setSymbolClass(SQLQuerySymbolClass.ERROR);
            }
        }
        SQLQueryDataContext combinedContext = left.combine(right);
        if (this.condition != null) {
            this.condition.propagateContext(combinedContext, statistics);
        }
        return combinedContext;
    }
}

