/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSourceModel;

public class SQLQueryDummyDataSourceContext
extends SQLQueryDataContext {
    private final DummyDbObject dummyDataSource;
    private final DummyDbObject defaultDummyCatalog;
    private final DummyDbObject defaultDummySchema;
    private final Set<String> knownColumnNames;
    private final Set<String> knownTableNames;
    private final Set<String> knownSchemaNames;
    private final Set<String> knownCatalogNames;

    public SQLQueryDummyDataSourceContext(@NotNull Set<String> knownColumnNames, @NotNull Set<List<String>> knownTableNames) {
        this.knownColumnNames = knownColumnNames;
        this.knownTableNames = new HashSet<String>();
        this.knownSchemaNames = new HashSet<String>();
        this.knownCatalogNames = new HashSet<String>();
        for (List<String> name : knownTableNames) {
            this.knownTableNames.add(name.get(name.size() - 1));
            if (name.size() <= 1) continue;
            this.knownSchemaNames.add(name.get(name.size() - 2));
            if (name.size() <= 2) continue;
            this.knownCatalogNames.add(name.get(name.size() - 3));
        }
        if (this.knownCatalogNames.isEmpty()) {
            this.knownCatalogNames.add("dummyCatalog");
        }
        if (this.knownSchemaNames.isEmpty()) {
            this.knownSchemaNames.add("dummySchema");
        }
        this.dummyDataSource = this.prepareDataSource();
        this.defaultDummyCatalog = this.dummyDataSource.getChildrenMapImpl().values().stream().findFirst().get();
        this.defaultDummySchema = this.defaultDummyCatalog.getChildrenMapImpl().values().stream().findFirst().get();
    }

    private DummyDbObject prepareDataSource() {
        return new DummyDbObject(null, "DummyDataSource", "Dummy data source for purposes of static query semantic analysis", 0, this.knownCatalogNames, this::prepareCatalog);
    }

    private DummyDbObject prepareCatalog(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, name, "Dummy catalog for purposes of static query semantic analysis", index, this.knownSchemaNames, this::prepareSchema);
    }

    private DummyDbObject prepareSchema(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, name, "Dummy schema for purposes of static query semantic analysis", index, this.knownTableNames, this::prepareTable);
    }

    private DummyDbObject prepareTable(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, name, "Dummy table for purposes of static query semantic analysis", index, this.knownColumnNames, this::prepareColumn);
    }

    private DummyDbObject prepareColumn(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, name, "Dummy column for purposes of static query semantic analysis", index, Collections.emptySet(), null);
    }

    @Override
    public List<SQLQuerySymbol> getColumnsList() {
        return Collections.emptyList();
    }

    @Override
    public DBSEntity findRealTable(List<String> tableName) {
        DummyDbObject source = this.dummyDataSource;
        DummyDbObject catalog = tableName.size() > 2 ? source.getChildrenMapImpl().get(tableName.get(tableName.size() - 3)) : this.defaultDummyCatalog;
        DummyDbObject schema = tableName.size() > 1 ? catalog.getChildrenMapImpl().get(tableName.get(tableName.size() - 2)) : this.defaultDummySchema;
        return (DBSEntity)schema.getChildrenMapImpl().get(tableName.get(tableName.size() - 1));
    }

    @Override
    public SQLQueryRowsSourceModel findRealSource(DBSEntity table) {
        return null;
    }

    @Override
    public SQLQuerySymbolDefinition resolveColumn(String simpleName) {
        return null;
    }

    @Override
    public SQLDialect getDialect() {
        return BasicSQLDialect.INSTANCE;
    }

    @Override
    public SQLQueryRowsSourceModel getDefaultTable() {
        return new DummyTableRowsSource();
    }

    private class DummyDbObject
    implements DBSEntityAttribute,
    DBSTable,
    DBSSchema,
    DBSCatalog,
    DBPDataSource {
        private final DummyDbObject container;
        private final String name;
        private final String description;
        private final int position;
        private final Set<String> childrenNames;
        private final DummyObjectCtor childCtor;
        private Map<String, DummyDbObject> childrenByName = null;
        private List<DummyDbObject> children = null;

        public DummyDbObject(DummyDbObject container, String name, String description, int position, Set<String> childrenNames, DummyObjectCtor childCtor) {
            this.container = container;
            this.name = name;
            this.description = description;
            this.position = position;
            this.childrenNames = childrenNames;
            this.childCtor = childCtor;
        }

        private Map<String, DummyDbObject> getChildrenMapImpl() {
            if (this.childrenByName == null) {
                if (this.childCtor == null) {
                    this.childrenByName = Collections.emptyMap();
                } else {
                    this.childrenByName = new HashMap<String, DummyDbObject>();
                    int i = 0;
                    for (String name : this.childrenNames) {
                        this.childrenByName.put(name, this.childCtor.apply(this, name, i++));
                    }
                }
            }
            return this.childrenByName;
        }

        private List<DummyDbObject> getChildrenListImpl() {
            return this.children != null ? this.children : (this.children = new ArrayList<DummyDbObject>(this.getChildrenMapImpl().values()));
        }

        @NotNull
        public DBSEntity getParentObject() {
            return this.container;
        }

        public DBPDataSource getDataSource() {
            return SQLQueryDummyDataSourceContext.this.dummyDataSource;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isPersisted() {
            return true;
        }

        public int getOrdinalPosition() {
            return this.position;
        }

        public boolean isRequired() {
            return true;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public String getTypeName() {
            return null;
        }

        public String getFullTypeName() {
            return null;
        }

        public int getTypeID() {
            return 0;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.STRING;
        }

        public Integer getScale() {
            return null;
        }

        public Integer getPrecision() {
            return null;
        }

        public long getMaxLength() {
            return 0L;
        }

        public long getTypeModifiers() {
            return 0L;
        }

        public String getDefaultValue() {
            return null;
        }

        public DBSEntityType getEntityType() {
            return DBSEntityType.TABLE;
        }

        public List<? extends DBSEntityAttribute> getAttributes(DBRProgressMonitor monitor) throws DBException {
            return this.getChildrenListImpl();
        }

        public DBSEntityAttribute getAttribute(DBRProgressMonitor monitor, String attributeName) throws DBException {
            return this.getChildrenMapImpl().get(attributeName);
        }

        public Collection<? extends DBSEntityAssociation> getAssociations(DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }

        public Collection<? extends DBSEntityAssociation> getReferences(DBRProgressMonitor monitor) throws DBException {
            return null;
        }

        @NotNull
        public String getFullyQualifiedName(DBPEvaluationContext context) {
            StringBuilder sb = new StringBuilder();
            DummyDbObject o = this;
            while (o != null) {
                sb.append(BasicSQLDialect.INSTANCE.getQuotedIdentifier(o.getName(), false, false));
                o = o.getParentObject();
            }
            return sb.toString();
        }

        public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
            return this.getChildrenListImpl();
        }

        public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
            return (DBSObject)this.getChildrenMapImpl().get(childName);
        }

        @NotNull
        public Class<? extends DBSObject> getPrimaryChildType(DBRProgressMonitor monitor) throws DBException {
            return DummyDbObject.class;
        }

        public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        }

        public DBSInstance getDefaultInstance() {
            return null;
        }

        @NotNull
        public Collection<? extends DBSInstance> getAvailableInstances() {
            return Collections.emptyList();
        }

        public void shutdown(DBRProgressMonitor monitor) {
        }

        public Map<String, ?> getContextAttributes() {
            return Collections.emptyMap();
        }

        public <T> T getContextAttribute(String attributeName) {
            return null;
        }

        public <T> void setContextAttribute(String attributeName, T attributeValue) {
        }

        public void removeContextAttribute(String attributeName) {
        }

        public DBPDataSourceContainer getContainer() {
            return null;
        }

        public DBPDataSourceInfo getInfo() {
            return null;
        }

        public Object getDataSourceFeature(String featureId) {
            return null;
        }

        public SQLDialect getSQLDialect() {
            return BasicSQLDialect.INSTANCE;
        }

        public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        }

        public boolean isView() {
            return false;
        }

        public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }

        public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }

        public List<? extends DBSTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }
    }

    @FunctionalInterface
    private static interface DummyObjectCtor {
        public DummyDbObject apply(DummyDbObject var1, String var2, int var3);
    }

    private class DummyTableRowsSource
    extends SQLQueryRowsSourceModel
    implements SQLQuerySymbolDefinition {
        @Override
        public SQLQuerySymbolClass getSymbolClass() {
            return SQLQuerySymbolClass.TABLE;
        }

        @Override
        protected SQLQueryDataContext propagateContextImpl(SQLQueryDataContext context, SQLQueryRecognitionContext statistics) {
            context = context.overrideResultTuple(SQLQueryDummyDataSourceContext.this.knownColumnNames.stream().map(s -> new SQLQuerySymbol((String)s)).collect(Collectors.toList()));
            return context;
        }
    }
}

