/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.utils.CommonUtils;

public class TaskPropertyTester
extends PropertyTester {
    private static final Log log = Log.getLog(TaskPropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.task";
    public static final String PROP_SCHEDULED = "scheduled";
    public static final String PROP_EDITABLE = "editable";
    public static final String PROP_CAN_OPEN_SCHEDULER_SETTINGS = "canOpenSchedulerSettings";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof DBTTaskFolder && PROP_EDITABLE.equals(property)) {
            return ((DBTTaskFolder)receiver).getProject().hasRealmPermission("project-datasource-edit");
        }
        if (!(receiver instanceof DBTTask var5_6)) {
            return false;
        }
        DBTScheduler scheduler = TaskRegistry.getInstance().getActiveSchedulerInstance();
        switch (property) {
            case "scheduled": {
                if (scheduler != null && scheduler.getScheduledTaskInfo((DBTTask)task) != null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "editable": {
                boolean bl = task.getProject().hasRealmPermission("project-datasource-edit");
                break;
            }
            case "canOpenSchedulerSettings": {
                if (scheduler != null && scheduler.supportsFeature("openExternalSettings")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = actualValue = false;
            }
        }
        return actualValue == CommonUtils.getBoolean((Object)expectedValue, (boolean)true);
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.task." + propName));
    }
}

