/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping.internal;

import java.util.ArrayList;
import java.util.Map;
import org.jkiss.code.NotNull;

public enum FieldTypeKind {
    String(true),
    Byte(true),
    Short(true),
    Int(true),
    Long(true),
    Bool(true),
    Float(true),
    Double(true),
    Enum(true),
    LiteralList(true),
    Object(false),
    Array(false),
    List(false);

    public final boolean isTerm;
    private static final Map<Class<?>, FieldTypeKind> builtinTypeKinds;

    static {
        builtinTypeKinds = Map.ofEntries(Map.entry(String.class, String), Map.entry(Byte.class, Byte), Map.entry(Short.class, Short), Map.entry(Integer.class, Int), Map.entry(Long.class, Long), Map.entry(Boolean.class, Bool), Map.entry(Float.class, Float), Map.entry(Double.class, Double), Map.entry(java.lang.Byte.TYPE, Byte), Map.entry(java.lang.Short.TYPE, Short), Map.entry(Integer.TYPE, Int), Map.entry(java.lang.Long.TYPE, Long), Map.entry(Boolean.TYPE, Bool), Map.entry(java.lang.Float.TYPE, Float), Map.entry(java.lang.Double.TYPE, Double));
    }

    private FieldTypeKind(boolean isTerm) {
        this.isTerm = isTerm;
    }

    @NotNull
    public static FieldTypeKind resolveModelLiteralFieldKind(@NotNull Class<?> fieldType) {
        FieldTypeKind kind = builtinTypeKinds.get(fieldType);
        if (kind == null) {
            kind = fieldType.isEnum() ? Enum : (fieldType.isAssignableFrom(ArrayList.class) ? LiteralList : String);
        }
        return kind;
    }

    @NotNull
    public static FieldTypeKind resolveModelSubnodeFieldKind(@NotNull Class<?> fieldType) {
        FieldTypeKind kind = fieldType.isArray() ? Array : (fieldType.isAssignableFrom(ArrayList.class) ? List : Object);
        return kind;
    }
}

