/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping.internal;

import java.util.Iterator;
import java.util.Stack;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathNodes;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodesList;
import org.jkiss.dbeaver.model.lsm.mapping.internal.TreeRuleNode;
import org.jkiss.dbeaver.model.lsm.mapping.internal.XTreeTextBase;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CustomXPathUtils {
    public static void flattenExclusiveImpl(@NotNull Node root, @NotNull XPathExpression expr, boolean justLeaves, @NotNull NodesList<Node> result) throws XPathExpressionException {
        Stack<Node> stack = new Stack<Node>();
        stack.add(root);
        while (stack.size() > 0) {
            Node node = (Node)stack.pop();
            XPathNodes subnodes = expr.evaluateExpression(node, XPathNodes.class);
            if (justLeaves) {
                if (subnodes.size() > 0) {
                    CustomXPathUtils.reverseIterableOf(subnodes).forEach(stack::add);
                    continue;
                }
                result.add(node);
                continue;
            }
            result.ensureCapacity(result.size() + subnodes.size());
            subnodes.forEach(result::add);
            CustomXPathUtils.reverseIterableOf(subnodes).forEach(stack::add);
        }
    }

    @NotNull
    public static Stream<Node> streamOf(@NotNull NodeList list) {
        return StreamSupport.stream(CustomXPathUtils.iterableOf(list).spliterator(), false);
    }

    @NotNull
    public static Iterable<Node> iterableOf(final @NotNull NodeList list) {
        return () -> new Iterator<Node>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < list.getLength();
            }

            @Override
            public Node next() {
                return list.item(this.index++);
            }
        };
    }

    @NotNull
    public static Iterable<Node> reverseIterableOf(final @NotNull XPathNodes list) {
        return () -> new Iterator<Node>(){
            private int index;
            {
                this.index = xPathNodes.size();
            }

            @Override
            public boolean hasNext() {
                return this.index > 0;
            }

            @Override
            public Node next() {
                try {
                    return list.get(--this.index);
                }
                catch (XPathException xPathException) {
                    return null;
                }
            }
        };
    }

    @Nullable
    public static String getText(@NotNull Tree node) {
        String result = null;
        if (node instanceof TreeRuleNode) {
            TreeRuleNode ruleNode = (TreeRuleNode)node;
            Interval textRange = ruleNode.getRealInterval();
            result = ruleNode.getStart().getInputStream().getText(textRange);
        } else if (node instanceof XTreeTextBase) {
            Interval textRange = ((XTreeTextBase)node).getRealInterval();
            result = ((TerminalNode)node).getSymbol().getInputStream().getText(textRange);
        } else if (node instanceof ParseTree) {
            result = ((ParseTree)node).getText();
        } else {
            Tree first = node;
            Tree last = node;
            while (!(first instanceof TerminalNode) && first.getChildCount() > 0) {
                first = first.getChild(0);
            }
            while (!(last instanceof TerminalNode) && last.getChildCount() > 0) {
                last = last.getChild(last.getChildCount() - 1);
            }
            if (first instanceof TerminalNode && last instanceof TerminalNode) {
                TerminalNode a = (TerminalNode)first;
                TerminalNode b = (TerminalNode)last;
                Interval textRange = Interval.of((int)a.getSymbol().getStartIndex(), (int)b.getSymbol().getStopIndex());
                result = b.getSymbol().getTokenSource().getInputStream().getText(textRange);
            }
        }
        return result;
    }
}

