/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.app;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import java.util.LinkedHashMap;
import org.eclipse.equinox.app.IApplicationContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.dpi.app.DPIPlatform;
import org.jkiss.dbeaver.dpi.model.client.ConfigUtils;
import org.jkiss.dbeaver.dpi.server.DPIRestServer;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.registry.DesktopApplicationImpl;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.IOUtils;

public class DPIApplication
extends DesktopApplicationImpl {
    private static final Log log = Log.getLog(DPIApplication.class);

    public boolean isHeadlessMode() {
        return true;
    }

    public boolean isDetachedProcess() {
        return true;
    }

    public Object start(IApplicationContext context) {
        DPIPlatform.createInstance();
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        try {
            this.runServer(context, application);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        log.debug((Object)"Exiting DPI application");
        return EXIT_OK;
    }

    private void runServer(IApplicationContext appContext, DBPApplication application) throws IOException {
        int portNumber = IOUtils.findFreePort((int)20000, (int)65000);
        DPIRestServer server = new DPIRestServer(application, portNumber);
        this.saveServerInfo(portNumber);
        try {
            log.debug((Object)("Started DPI Server at " + portNumber));
            server.join();
        }
        finally {
            this.deleteServerInfo();
        }
    }

    private void saveServerInfo(int portNumber) throws IOException {
        Path serverIniFile = this.getServerIniFile();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter out = Files.newBufferedWriter(serverIniFile, StandardOpenOption.CREATE);){
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("serverPort", String.valueOf(portNumber));
            props.put("startTime", new Date().toString());
            ConfigUtils.storeProperties((BufferedWriter)out, props);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void deleteServerInfo() throws IOException {
        Path serverIniFile = this.getServerIniFile();
        if (Files.exists(serverIniFile, new LinkOption[0])) {
            Files.delete(serverIniFile);
        }
    }

    @NotNull
    private Path getServerIniFile() throws IOException {
        String configPath = System.getProperty("osgi.configuration.area");
        if (configPath == null) {
            throw new IOException("OSGI configuration area property not set");
        }
        Path configFolder = Path.of(configPath = this.normalizeFileReference(configPath), new String[0]);
        if (!Files.exists(configFolder, new LinkOption[0])) {
            throw new IOException("Configuration folder '" + configFolder + "' doesn't exists");
        }
        Path serverIniFile = configFolder.resolve("server.ini");
        return serverIniFile;
    }

    @NotNull
    private String normalizeFileReference(String configPath) {
        if (configPath.startsWith("file:")) {
            configPath = configPath.substring(configPath.indexOf(58) + 1);
        }
        while (configPath.contains(":/") && configPath.startsWith("/")) {
            configPath = configPath.substring(1);
        }
        return configPath;
    }

    public void stop() {
        System.out.println("Stopping DPI application");
        super.stop();
    }

    @Nullable
    public Path getDefaultWorkingFolder() {
        return null;
    }

    public String getDefaultProjectName() {
        return "default";
    }
}

