/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPResourceCreator;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.fs.DBFFileStoreProvider;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.ObjectPropertyTester;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateBase;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectCreateNew
extends NavigatorHandlerObjectCreateBase
implements IElementUpdater {
    private static final Log log = Log.getLog(NavigatorHandlerObjectCreateNew.class);
    public static final Separator DUMMY_CONTRIBUTION_ITEM = new Separator();
    private MenuManager menuManager;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String objectType = event.getParameter("org.jkiss.dbeaver.core.object.type");
        boolean isFolder = CommonUtils.toBoolean((Object)event.getParameter("org.jkiss.dbeaver.core.object.folder"));
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection.isEmpty()) {
            return null;
        }
        DBNNode node = NavigatorHandlerObjectCreateNew.getNodeFromSelection(selection);
        if (node != null) {
            Class newObjectType = null;
            if (objectType != null) {
                if (node instanceof DBNDatabaseNode) {
                    newObjectType = ((DBNDatabaseNode)node).getMeta().getSource().getObjectClass(objectType);
                } else {
                    try {
                        newObjectType = Class.forName(objectType);
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)("Error detecting new object type " + objectType), (Throwable)e);
                    }
                }
            } else {
                IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (activePart != null) {
                    ParameterizedCommand[] commands = (ParameterizedCommand[])NavigatorHandlerObjectCreateNew.fillCreateMenuItems(activePart.getSite(), node).stream().filter(item -> item instanceof CommandContributionItem).map(item -> (CommandContributionItem)item).map(CommandContributionItem::getCommand).filter(Objects::nonNull).filter(command -> command.getId().contains(".create")).toArray(ParameterizedCommand[]::new);
                    if (commands.length == 1) {
                        ActionUtils.runCommand((String)commands[0].getId(), (ISelection)selection, (Map)commands[0].getParameterMap(), (IServiceLocator)activePart.getSite());
                        return null;
                    }
                    if (commands.length > 1) {
                        this.showPopupMenu(event, node);
                        return null;
                    }
                }
            }
            this.createNewObject(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), node, newObjectType, null, isFolder);
        }
        return null;
    }

    @Nullable
    static DBNNode getNodeFromSelection(ISelection selection) {
        DBNNode node = null;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            node = (DBNNode)RuntimeUtils.getObjectAdapter((Object)selectedObject, DBNNode.class);
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    public void updateElement(UIElement element, Map parameters) {
        DBNNode node;
        if (!updateUI) {
            return;
        }
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return;
        }
        ISelectionProvider selectionProvider = UIUtils.getSelectionProvider((IServiceLocator)element.getServiceLocator());
        if (selectionProvider == null) {
            return;
        }
        Object typeName = parameters.get("org.jkiss.dbeaver.core.object.typeName");
        Object objectIcon = parameters.get("org.jkiss.dbeaver.core.object.typeIcon");
        if (typeName == null && (node = NavigatorHandlerObjectCreateNew.getNodeFromSelection(selectionProvider.getSelection())) != null && !node.isDisposed()) {
            List<IContributionItem> actions = NavigatorHandlerObjectCreateNew.fillCreateMenuItems(workbenchWindow.getActivePage().getActivePart().getSite(), node);
            for (IContributionItem item : actions) {
                void cci;
                ParameterizedCommand command;
                CommandContributionItem commandContributionItem;
                IContributionItem iContributionItem = item;
                if (!(iContributionItem instanceof CommandContributionItem) || (commandContributionItem = (CommandContributionItem)iContributionItem) != (CommandContributionItem)iContributionItem || (command = cci.getCommand()) == null) continue;
                typeName = command.getParameterMap().get("org.jkiss.dbeaver.core.object.typeName");
                if (typeName == null) break;
                typeName = NLS.bind((String)UINavigatorMessages.actions_navigator_create_new, typeName);
                break;
            }
        }
        if (typeName != null) {
            element.setText(typeName.toString());
        } else {
            element.setText(NLS.bind((String)UINavigatorMessages.actions_navigator_create_new, (Object)NavigatorHandlerObjectCreateNew.getObjectTypeName(element)));
        }
        if (objectIcon != null) {
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)new DBIcon(objectIcon.toString())));
        } else {
            DBPImage image = NavigatorHandlerObjectCreateNew.getObjectTypeIcon(selectionProvider);
            if (image == null) {
                image = DBIcon.TYPE_OBJECT;
            }
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)image));
        }
    }

    public static String getObjectTypeName(UIElement element) {
        DBNNode node = NavigatorUtils.getSelectedNode(element);
        if (node != null) {
            if (node instanceof DBNContainer && !(node instanceof DBNDataSource)) {
                return ((DBNContainer)node).getChildrenType();
            }
            return node.getNodeTypeLabel();
        }
        return null;
    }

    public static DBPImage getObjectTypeIcon(ISelectionProvider selectionProvider) {
        DBNNode node = NavigatorHandlerObjectCreateNew.getNodeFromSelection(selectionProvider.getSelection());
        if (node != null) {
            if (!(node instanceof DBNDatabaseFolder) && node.getParentNode() instanceof DBNDatabaseFolder) {
                node = node.getParentNode();
            }
            if (node instanceof DBNDataSource) {
                return UIIcon.SQL_CONNECT;
            }
            if (node instanceof DBNDatabaseFolder) {
                List metaChildren = ((DBNDatabaseFolder)node).getMeta().getChildren(node);
                if (!CommonUtils.isEmpty((Collection)metaChildren)) {
                    return ((DBXTreeNode)metaChildren.get(0)).getIcon(null);
                }
                return null;
            }
            return node.getNodeIconDefault();
        }
        return null;
    }

    public static List<IContributionItem> fillCreateMenuItems(@Nullable IWorkbenchPartSite site, DBNNode node) {
        boolean projectConnectionEditable;
        ArrayList<IContributionItem> createActions = new ArrayList<IContributionItem>();
        boolean projectResourceEditable = node == null || ObjectPropertyTester.nodeProjectHasPermission(node, "project-resource-edit");
        boolean bl = projectConnectionEditable = node == null || ObjectPropertyTester.nodeProjectHasPermission(node, "project-datasource-edit");
        if ((node instanceof DBNLocalFolder || node instanceof DBNProjectDatabases) && projectConnectionEditable) {
            IContributionItem item = NavigatorHandlerObjectCreateNew.makeCreateContributionItem(site, DBPDataSourceContainer.class.getName(), ModelMessages.model_navigator_Connection, (DBPImage)UIIcon.SQL_NEW_CONNECTION, false);
            createActions.add(item);
        }
        if (node instanceof DBNDatabaseNode) {
            NavigatorHandlerObjectCreateNew.addDatabaseNodeCreateItems(site, createActions, (DBNDatabaseNode)node);
        }
        if ((node instanceof DBNLocalFolder || node instanceof DBNProjectDatabases || node instanceof DBNDataSource) && projectConnectionEditable) {
            createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.new.folder"));
        } else {
            DBPWorkspaceDesktop workspace = DBPPlatformDesktop.getInstance().getWorkspace();
            IResource resource = (IResource)GeneralUtils.adapt((Object)node, IResource.class);
            if (resource != null) {
                DBPResourceHandler handler;
                if (resource instanceof IProject && !DBWorkbench.isDistributed()) {
                    createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.project.create"));
                }
                if ((handler = workspace.getResourceHandler(resource)) instanceof DBPResourceCreator && (handler.getFeatures(resource) & 0x20) != 0 && projectResourceEditable) {
                    createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.resource.create.file"));
                }
                if (handler != null && (handler.getFeatures(resource) & 4) != 0 && projectResourceEditable) {
                    createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.resource.create.folder"));
                }
                if (resource instanceof IContainer && !(resource instanceof DBFFileStoreProvider) && projectResourceEditable && !DBWorkbench.isDistributed()) {
                    createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.resource.link.file"));
                    createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.resource.link.folder"));
                }
            }
        }
        if (site != null) {
            if (!createActions.isEmpty() && !(createActions.get(createActions.size() - 1) instanceof Separator)) {
                createActions.add((IContributionItem)new Separator());
            }
            createActions.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)site, (String)"org.eclipse.ui.newWizard", (String)UINavigatorMessages.navigator_handler_object_create_file_other_text, null));
        }
        return createActions;
    }

    private void showPopupMenu(@NotNull ExecutionEvent event, @NotNull DBNNode node) throws ExecutionException {
        Control focusControl;
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Control control = focusControl = activeShell != null ? activeShell.getDisplay().getFocusControl() : null;
        if (part == null || activeShell == null || focusControl == null) {
            return;
        }
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        this.menuManager = new MenuManager();
        for (IContributionItem item : NavigatorHandlerObjectCreateNew.fillCreateMenuItems(part.getSite(), node)) {
            this.menuManager.add(item);
        }
        Menu contextMenu = this.menuManager.createContextMenu(focusControl);
        contextMenu.addMenuListener(MenuListener.menuShownAdapter(e -> {
            int index = 0;
            MenuItem[] menuItemArray = contextMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                if (CommonUtils.isNotEmpty((String)item.getText())) {
                    item.setText(ActionUtils.getLabelWithIndexMnemonic((String)item.getText(), (int)index));
                    ++index;
                }
                ++n2;
            }
        }));
        Point location = ActionUtils.getLocationFromControl((Shell)activeShell, (Control)focusControl);
        if (location != null) {
            contextMenu.setLocation(location);
        }
        contextMenu.setVisible(true);
    }

    private static void addDatabaseNodeCreateItems(@Nullable IWorkbenchPartSite site, List<IContributionItem> createActions, DBNDatabaseNode node) {
        block17: {
            List childNodeMetas;
            block16: {
                DBXTreeFolder.ItemType[] itemTypes;
                if (!(node instanceof DBNDatabaseFolder)) break block16;
                DBXTreeFolder folderMeta = ((DBNDatabaseFolder)node).getMeta();
                List metaChildren = folderMeta.getChildren((DBNNode)node);
                if (!CommonUtils.isEmpty((Collection)metaChildren)) {
                    Class nodeClass = null;
                    if (metaChildren.size() == 1 && metaChildren.get(0) instanceof DBXTreeItem) {
                        nodeClass = node.getChildrenClass((DBXTreeItem)metaChildren.get(0));
                    }
                    Class childrenClass = ((DBNDatabaseFolder)node).getChildrenClass();
                    if (nodeClass == null || childrenClass != null && nodeClass.isAssignableFrom(childrenClass)) {
                        nodeClass = childrenClass;
                    }
                    if (nodeClass == null) {
                        nodeClass = ((DBNDatabaseFolder)node).getChildrenClass();
                    }
                    String nodeType = ((DBXTreeNode)metaChildren.get(0)).getChildrenTypeLabel(node.getDataSource(), null);
                    if (nodeClass != null && nodeType != null && NavigatorHandlerObjectCreateNew.isCreateSupported((DBNNode)node, nodeClass)) {
                        DBPImage nodeIcon = node.getNodeIconDefault();
                        IContributionItem item = NavigatorHandlerObjectCreateNew.makeCreateContributionItem(site, nodeClass.getName(), nodeType, nodeIcon, false);
                        createActions.add(item);
                    }
                }
                if ((itemTypes = folderMeta.getItemTypes()) == null) break block17;
                DBXTreeFolder.ItemType[] itemTypeArray = itemTypes;
                int item = itemTypes.length;
                int n = 0;
                while (n < item) {
                    DBXTreeFolder.ItemType itemType = itemTypeArray[n];
                    Class itemClass = folderMeta.getSource().getObjectClass(itemType.getClassName(), Object.class);
                    if (itemClass != null && NavigatorHandlerObjectCreateNew.isCreateSupported((DBNNode)node, itemClass)) {
                        IContributionItem item2 = NavigatorHandlerObjectCreateNew.makeCreateContributionItem(site, itemType.getClassName(), itemType.getItemType(), itemType.getItemIcon(), false);
                        createActions.add(item2);
                    }
                    ++n;
                }
                break block17;
            }
            if (node.getObject() == null) {
                return;
            }
            Class<?> nodeItemClass = node.getObject().getClass();
            DBNNode parentNode = node.getParentNode();
            if (NavigatorHandlerObjectCreateNew.isCreateSupported(parentNode, nodeItemClass)) {
                if (site == null) {
                    createActions.add((IContributionItem)DUMMY_CONTRIBUTION_ITEM);
                } else {
                    DBIcon nodeIcon = node instanceof DBNDataSource ? UIIcon.SQL_NEW_CONNECTION : node.getNodeIconDefault();
                    createActions.add(NavigatorHandlerObjectCreateNew.makeCreateContributionItem(site, nodeItemClass.getName(), node.getNodeTypeLabel(), (DBPImage)nodeIcon, false));
                }
            }
            if (!node.getDataSourceContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA)) {
                return;
            }
            if (site != null) {
                createActions.add((IContributionItem)new Separator());
            }
            if (!CommonUtils.isEmpty((Collection)(childNodeMetas = node.getMeta().getChildren((DBNNode)node)))) {
                for (DBXTreeNode childMeta : childNodeMetas) {
                    if (childMeta instanceof DBXTreeFolder) {
                        List folderChildMeta = childMeta.getChildren((DBNNode)node);
                        if (CommonUtils.isEmpty((Collection)folderChildMeta) || folderChildMeta.size() != 1 || !(folderChildMeta.get(0) instanceof DBXTreeItem)) continue;
                        NavigatorHandlerObjectCreateNew.addChildNodeCreateItem(site, createActions, node, (DBXTreeItem)folderChildMeta.get(0));
                        continue;
                    }
                    if (!(childMeta instanceof DBXTreeItem)) continue;
                    NavigatorHandlerObjectCreateNew.addChildNodeCreateItem(site, createActions, node, (DBXTreeItem)childMeta);
                }
            }
        }
    }

    private static boolean addChildNodeCreateItem(@Nullable IWorkbenchPartSite site, List<IContributionItem> createActions, DBNDatabaseNode node, DBXTreeItem childMeta) {
        if (childMeta.isVirtual()) {
            return false;
        }
        Class objectClass = node.getChildrenClass(childMeta);
        if (objectClass != null) {
            if (!NavigatorHandlerObjectCreateNew.isCreateSupported((DBNNode)node, objectClass)) {
                return false;
            }
            String typeName = childMeta.getNodeTypeLabel(node.getDataSource(), null);
            if (typeName != null) {
                IContributionItem item = NavigatorHandlerObjectCreateNew.makeCreateContributionItem(site, objectClass.getName(), typeName, childMeta.getIcon(null), true);
                createActions.add(item);
                return true;
            }
        }
        return false;
    }

    private static boolean isCreateSupported(DBNNode parentNode, Class<?> objectClass) {
        DBEObjectMaker objectMaker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(objectClass, DBEObjectMaker.class);
        return objectMaker != null && objectMaker.canCreateObject(parentNode instanceof DBNDatabaseNode ? ((DBNDatabaseNode)parentNode).getValueObject() : parentNode.getOwnerProject());
    }

    private static IContributionItem makeCommandContributionItem(@Nullable IWorkbenchPartSite site, String commandId) {
        if (site == null) {
            return DUMMY_CONTRIBUTION_ITEM;
        }
        return ActionUtils.makeCommandContribution((IServiceLocator)site, (String)commandId);
    }

    private static IContributionItem makeCreateContributionItem(@Nullable IWorkbenchPartSite site, String objectType, String objectTypeName, DBPImage objectIcon, boolean isFolder) {
        if (site == null) {
            return DUMMY_CONTRIBUTION_ITEM;
        }
        CommandContributionItemParameter params = new CommandContributionItemParameter((IServiceLocator)site, "org.jkiss.dbeaver.core.object.create", "org.jkiss.dbeaver.core.object.create", 8);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.jkiss.dbeaver.core.object.type", objectType);
        parameters.put("org.jkiss.dbeaver.core.object.typeName", objectTypeName);
        if (objectIcon != null) {
            parameters.put("org.jkiss.dbeaver.core.object.typeIcon", objectIcon.getLocation());
        }
        if (isFolder) {
            parameters.put("org.jkiss.dbeaver.core.object.folder", String.valueOf(true));
        }
        params.parameters = parameters;
        return new CommandContributionItem(params);
    }

    private static boolean isReadOnly(DBSObject object) {
        if (object == null) {
            return true;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null || dataSource.getContainer().isConnectionReadOnly();
    }

    public static class MenuCreateContributor
    extends CompoundContributionItem {
        private static final IContributionItem[] EMPTY_MENU = new IContributionItem[0];

        protected IContributionItem[] getContributionItems() {
            IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
            IWorkbenchPart activePart = activePage.getActivePart();
            if (activePart == null) {
                return EMPTY_MENU;
            }
            IWorkbenchPartSite site = activePart.getSite();
            DBNNode node = NavigatorHandlerObjectCreateNew.getNodeFromSelection(site.getSelectionProvider().getSelection());
            List<IContributionItem> createActions = NavigatorHandlerObjectCreateNew.fillCreateMenuItems(site, node);
            return createActions.toArray(new IContributionItem[0]);
        }
    }
}

