/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;

public class NavigatorHandlerConnectionFilter
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart;
        DatabaseNavigatorTree navigatorTree = DatabaseNavigatorTree.getFromShell(HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (navigatorTree == null && (activePart = HandlerUtil.getActivePart((ExecutionEvent)event)) instanceof DatabaseNavigatorView) {
            navigatorTree = ((DatabaseNavigatorView)activePart).getNavigatorTree();
        }
        if (navigatorTree != null) {
            navigatorTree.setFilterShowConnected(!navigatorTree.isFilterShowConnected());
            navigatorTree.getViewer().getControl().setRedraw(false);
            try {
                navigatorTree.getViewer().refresh();
            }
            finally {
                navigatorTree.getViewer().getControl().setRedraw(true);
            }
        }
        ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.navigator.filter.connected"});
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchPartSite partSite;
        DatabaseNavigatorTree navigatorTree = DatabaseNavigatorTree.getFromShell(Display.getCurrent());
        if (navigatorTree == null && (partSite = UIUtils.getWorkbenchPartSite((IServiceLocator)element.getServiceLocator())) != null && partSite.getPart() instanceof DatabaseNavigatorView) {
            navigatorTree = ((DatabaseNavigatorView)partSite.getPart()).getNavigatorTree();
        }
        if (navigatorTree != null) {
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)(navigatorTree.isFilterShowConnected() ? UIIcon.FILTER_RESET : UIIcon.FILTER_APPLY)));
            String actionName = navigatorTree.isFilterShowConnected() ? UINavigatorMessages.navigator_handler_connections_filter_show_all_text : UINavigatorMessages.navigator_handler_connections_filter_show_connected_text;
            element.setText(actionName);
            element.setTooltip(actionName);
        }
    }
}

