/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.osgi.service.prefs.BackingStoreException;

public class FontSelection {
    public static final String VAR_FONT_STYLE = "fontStyle";
    public static final String FONT_ABSOLUTE = "absolute";
    public static final String FONT_RELATIVE = "relative";
    private static final String SCALE_FACTOR = "scaleFactor";
    public static final String ATT_SCALABLE = "scalable";
    private static final int MIN_HEIGHT = 10;
    private static final int MAX_HEIGHT = 16;

    private static int getDefaultFontHeight() {
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData[] fontData = defaultFont.getFontData();
        int height = 10;
        int i = 0;
        while (i < fontData.length) {
            FontData data = fontData[i];
            height = Math.max(height, data.getHeight());
            ++i;
        }
        return Math.min(height, 16);
    }

    public static String generatePageFontStyle() {
        int defaultFontHeight = FontSelection.getDefaultFontHeight();
        int scale = FontSelection.getScalePercentage();
        Object result = FontSelection.getFontSizeDeclaration("", defaultFontHeight, 100, scale);
        result = (String)result + FontSelection.getFontSizeDeclaration("h1", defaultFontHeight, 200, scale);
        result = (String)result + FontSelection.getFontSizeDeclaration("h2", defaultFontHeight, 150, scale);
        result = (String)result + FontSelection.getFontSizeDeclaration("h3", defaultFontHeight, 120, scale);
        result = (String)result + FontSelection.getFontSizeDeclaration("h4", defaultFontHeight, 100, scale);
        result = (String)result + FontSelection.getFontSizeDeclaration("h5", defaultFontHeight, 80, scale);
        result = (String)result + FontSelection.getFontSizeDeclaration("h6", defaultFontHeight, 70, scale);
        return result;
    }

    public static final int getScalePercentage() {
        int scale = Platform.getPreferencesService().getInt("org.eclipse.ui.intro", SCALE_FACTOR, 0, null);
        return scale;
    }

    private static String getFontSizeDeclaration(String element, int baseSize, int percentage, int scale) {
        if (scale > 75) {
            scale = 75;
        }
        int newSize = (int)((double)(baseSize * percentage) * 1.25 / (double)(100 - scale));
        return " body " + element + "{  font-size : " + newSize + "px; } ";
    }

    public static void setScalePercentage(int i) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ui.intro");
        prefs.putInt(SCALE_FACTOR, i);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static void resetScalePercentage() {
        IEclipsePreferences iprefs = InstanceScope.INSTANCE.getNode("org.eclipse.ui.intro");
        IEclipsePreferences dprefs = DefaultScope.INSTANCE.getNode("org.eclipse.ui.intro");
        String defaultScale = dprefs.get(SCALE_FACTOR, "0");
        iprefs.put(SCALE_FACTOR, defaultScale);
    }

    public static String getFontStyle() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            String pid = product.getId();
            String style = Platform.getPreferencesService().getString("org.eclipse.ui.intro", pid + "_fontStyle", "", null);
            if (style.length() > 0) {
                return style;
            }
            style = Platform.getPreferencesService().getString("org.eclipse.ui.intro", VAR_FONT_STYLE, "", null);
            if (style.length() > 0) {
                return style;
            }
        }
        return FONT_RELATIVE;
    }
}

