/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.internal;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesMapper;
import org.eclipse.equinox.internal.security.storage.StorageUtils;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.ui.app.standalone.internal.PatchClassLoaderHook;
import org.jkiss.dbeaver.ui.notifications.NotificationUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.bundle.EventHook;

public class CoreApplicationActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.ui.app.standalone";
    private static final boolean PATCH_ECLIPSE_CLASSES = false;
    private static final String DBEAVER_SECURE_DIR = "secure";
    private static final String DBEAVER_SECURE_FILE = "secure_storage";
    public static final String ARG_ECLIPSE_KEYRING = "-eclipse.keyring";
    private static CoreApplicationActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (Platform.getOS().equals("win32")) {
            String installPath = SystemVariablesResolver.getInstallPath();
            System.setProperty("jna.boot.library.path", installPath);
        }
        if (!Log.isQuietMode()) {
            HashSet activatedBundles = new HashSet();
            context.registerService(EventHook.class, (event, contexts) -> {
                String message = null;
                Bundle bundle = event.getBundle();
                if (event.getType() == 2) {
                    if (bundle.getState() == 32) {
                        message = "> Start " + CoreApplicationActivator.getBundleName(bundle) + " [" + bundle.getSymbolicName() + " " + bundle.getVersion() + "]";
                        activatedBundles.add(bundle.getSymbolicName());
                    }
                } else if (event.getType() == 256) {
                    activatedBundles.remove(bundle.getSymbolicName());
                }
                if (message != null) {
                    System.err.println(message);
                }
            }, null);
        }
        this.useCustomSecretStorage();
        DBeaverNotifications.setHandler((DBeaverNotifications.NotificationHandler)new DBeaverNotifications.NotificationHandler(){

            public void sendNotification(DBPDataSource dataSource, String id, String text, DBPMessageType messageType, Runnable feedback) {
                NotificationUtils.sendNotification((DBPDataSource)dataSource, (String)id, (String)text, (DBPMessageType)messageType, (Runnable)feedback);
            }

            public void sendNotification(String id, String title, String text, DBPMessageType messageType, Runnable feedback) {
                NotificationUtils.sendNotification((String)id, (String)title, (String)text, (DBPMessageType)messageType, (Runnable)feedback);
            }
        });
        plugin = this;
    }

    private static String getBundleName(Bundle bundle) {
        String bundleName = (String)bundle.getHeaders().get("Bundle-Name");
        if (CommonUtils.isEmpty((String)bundleName)) {
            bundleName = bundle.getSymbolicName();
        }
        return bundleName;
    }

    private void activateHooks(BundleContext context) {
        EquinoxContainer container = ((BundleContextImpl)context).getContainer();
        HookRegistry registry = container.getConfiguration().getHookRegistry();
        ArrayList<PatchClassLoaderHook> hooks = new ArrayList<PatchClassLoaderHook>(registry.getClassLoaderHooks());
        hooks.add(new PatchClassLoaderHook());
        List newHooks = Collections.unmodifiableList(hooks);
        try {
            Field hooksField = registry.getClass().getDeclaredField("classLoaderHooksRO");
            hooksField.setAccessible(true);
            hooksField.set(registry, newHooks);
        }
        catch (Throwable e) {
            this.getLog().error("Error initializing class loader hook", e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CoreApplicationActivator getDefault() {
        return plugin;
    }

    private void migrateFromEclipseStorage(Path storagePath) throws Exception {
        Path oldLocation = new File(StorageUtils.getDefaultLocation().getPath()).toPath();
        Files.createDirectories(storagePath.getParent(), new FileAttribute[0]);
        Files.copy(oldLocation, storagePath, StandardCopyOption.REPLACE_EXISTING);
    }

    private void useCustomSecretStorage() throws Exception {
        EnvironmentInfo environmentInfoService;
        Path storagePath = Path.of(RuntimeUtils.getWorkingDirectory((String)"DBeaverData"), new String[0]).resolve(DBEAVER_SECURE_DIR).resolve(DBEAVER_SECURE_FILE);
        if (!Files.exists(storagePath, new LinkOption[0])) {
            File defaultLocation = new File(StorageUtils.getDefaultLocation().getPath());
            if (defaultLocation.exists()) {
                this.migrateFromEclipseStorage(storagePath);
            } else {
                Files.createDirectories(storagePath.getParent(), new FileAttribute[0]);
                Files.createFile(storagePath, new FileAttribute[0]);
            }
        }
        if ((environmentInfoService = AuthPlugin.getDefault().getEnvironmentInfoService()) instanceof EquinoxConfiguration) {
            Object[] nonFrameworkArgs = environmentInfoService.getNonFrameworkArgs();
            if (Files.exists(storagePath, new LinkOption[0]) && !ArrayUtils.contains((Object[])nonFrameworkArgs, (Object)ARG_ECLIPSE_KEYRING)) {
                String[] updatedArgs = (String[])Arrays.copyOf(nonFrameworkArgs, nonFrameworkArgs.length + 2);
                updatedArgs[updatedArgs.length - 2] = ARG_ECLIPSE_KEYRING;
                updatedArgs[updatedArgs.length - 1] = storagePath.toString();
                ((EquinoxConfiguration)environmentInfoService).setAppArgs(updatedArgs);
                SecurePreferencesMapper.clearDefault();
            }
        }
        SecurePreferencesFactory.getDefault();
    }
}

