/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications.sounds;

import java.io.File;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ui.notifications.NotificationSound;
import org.jkiss.dbeaver.ui.notifications.NotificationSoundProvider;

public class FileSoundProvider
implements NotificationSoundProvider {
    private final File file;

    public FileSoundProvider(@NotNull File file) {
        this.file = file;
    }

    @Override
    @NotNull
    public NotificationSound create() throws DBException {
        try {
            return new ClipSound(this.file);
        }
        catch (Exception e) {
            throw new DBException("Can't load sound from file " + this.file, (Throwable)e);
        }
    }

    private static class ClipSound
    implements NotificationSound {
        private final Clip clip;
        private final Lock lock = new ReentrantLock();
        private final Condition donePlaying = this.lock.newCondition();

        public ClipSound(@NotNull File file) throws Exception {
            Throwable throwable = null;
            Object var3_4 = null;
            try (AudioInputStream is = AudioSystem.getAudioInputStream(file);){
                AudioFormat format = is.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                this.clip = (Clip)AudioSystem.getLine(info);
                this.clip.open(is);
                this.clip.addLineListener(event -> {
                    if (event.getType() == LineEvent.Type.STOP) {
                        try {
                            this.lock.lock();
                            this.donePlaying.signal();
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public void play(float volume) {
            if (volume > 0.0f && volume < 1.0f) {
                try {
                    FloatControl control = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                    if (control != null) {
                        control.setValue(20.0f * (float)Math.log10(volume));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.clip.setMicrosecondPosition(0L);
            this.clip.start();
            try {
                this.lock.lock();
                this.donePlaying.awaitUninterruptibly();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() {
            this.clip.close();
        }
    }
}

