/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.finder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomToolTipHandler;
import org.jkiss.dbeaver.ui.controls.finder.AdvancedListItem;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class AdvancedList
extends Canvas {
    private Point itemSize = new Point(64, 64);
    private final List<AdvancedListItem> items = new ArrayList<AdvancedListItem>();
    private AdvancedListItem selectedItem;
    private AdvancedListItem hoverItem;
    private final Color backgroundColor;
    private final Color selectionBackgroundColor;
    private final Color foregroundColor;
    private final Color selectionForegroundColor;
    private final Color hoverBackgroundColor;
    private final Point textSize;
    private final ScrollBar vScroll;
    private int topRowIndex;
    private int topRowOffset;
    private final CustomToolTipHandler toolTipHandler;

    public AdvancedList(Composite parent, int style) {
        super(parent, 0x20000200 | style);
        CSSUtils.setCSSClass((Widget)this, "List");
        this.backgroundColor = UIStyles.getDefaultTextBackground();
        this.foregroundColor = UIStyles.getDefaultTextForeground();
        this.selectionBackgroundColor = UIStyles.getDefaultTextSelectionBackground();
        this.selectionForegroundColor = UIStyles.getDefaultTextSelectionForeground();
        this.hoverBackgroundColor = UIUtils.getSharedTextColors().getColor(UIUtils.blend(this.selectionBackgroundColor.getRGB(), new RGB(255, 255, 255), 70));
        Font normalFont = this.getFont();
        FontData[] fontData = normalFont.getFontData();
        fontData[0].height = (float)((double)fontData[0].height - 1.3);
        Font smallFont = new Font(normalFont.getDevice(), fontData[0]);
        this.setFont(smallFont);
        this.addDisposeListener(e -> {
            smallFont.dispose();
            for (AdvancedListItem item : this.items) {
                item.dispose();
            }
        });
        if (parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(new GridData(1808));
        }
        this.setBackground(this.backgroundColor);
        this.vScroll = this.getVerticalBar();
        this.vScroll.setVisible(true);
        this.vScroll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedList.this.onVerticalScroll();
            }
        });
        GC gc = new GC((Drawable)this.getDisplay());
        this.textSize = gc.stringExtent("X");
        gc.dispose();
        this.addPaintListener(this::onPaint);
        this.addListener(11, event -> {
            this.updateMeasures();
            this.redraw();
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: 
                    case 0x1000007: 
                    case 0x1000008: {
                        if (AdvancedList.this.getSelectedItem() == null) break;
                        AdvancedList.this.navigateByKey(e);
                    }
                }
            }
        });
        this.addMouseMoveListener(this::onMouseMove);
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                AdvancedList.this.onMouseMove(e);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AdvancedList.this.notifyDefaultSelection();
            }

            public void mouseDown(MouseEvent e) {
                AdvancedListItem item = AdvancedList.this.getItemByPos(e.x, e.y);
                if (item != null) {
                    AdvancedList.this.setSelection(item);
                    AdvancedList.this.setFocus();
                }
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                if (AdvancedList.this.getSelectedItem() == null && !AdvancedList.this.items.isEmpty()) {
                    AdvancedList.this.setSelection(AdvancedList.this.items.get(0));
                }
            }
        });
        this.toolTipHandler = new CustomToolTipHandler((Control)this);
        this.initAccessible();
    }

    public void refreshFilters() {
        this.selectedItem = null;
        this.hoverItem = null;
        this.updateMeasures();
    }

    private void onMouseMove(MouseEvent e) {
        AdvancedListItem item = this.getItemByPos(e.x, e.y);
        if (item == this.hoverItem) {
            return;
        }
        AdvancedListItem[] redrawItems = new AdvancedListItem[]{item, this.hoverItem};
        this.hoverItem = item;
        if (item == null) {
            this.toolTipHandler.updateToolTipText(null);
        } else {
            String toolTipText;
            ILabelProvider labelProvider = item.getLabelProvider();
            if (labelProvider instanceof IToolTipProvider && !CommonUtils.isEmpty((String)(toolTipText = ((IToolTipProvider)labelProvider).getToolTipText(item.getData())))) {
                this.toolTipHandler.updateToolTipText(toolTipText);
            }
        }
        GC gc = new GC((Drawable)this);
        try {
            this.paintList(gc, redrawItems);
        }
        finally {
            gc.dispose();
        }
    }

    private AdvancedListItem getItemByPos(int x, int y) {
        Point size = this.getSize();
        if (x < 0 || y < 0 || x >= size.x || y >= size.y) {
            return null;
        }
        Point itemSize = this.getItemSize();
        int row = this.topRowIndex + (y + this.topRowOffset) / itemSize.y;
        int col = x / itemSize.x;
        if (col < 0 || col >= this.getItemsPerRow()) {
            return null;
        }
        int itemIndex = row * this.getItemsPerRow() + col;
        return itemIndex < this.items.size() ? this.items.get(itemIndex) : null;
    }

    private void onVerticalScroll() {
        this.redraw();
    }

    private void updateMeasures() {
        int itemsPerRow = this.getItemsPerRow();
        int totalRows = itemsPerRow == 0 ? 0 : this.items.size() / itemsPerRow + 2;
        int itemHeight = this.getItemSize().y;
        int visibleRowCount = this.getVisibleRowCount();
        this.vScroll.setValues(0, 0, totalRows * itemHeight, visibleRowCount * itemHeight, itemHeight / 2, itemHeight);
        this.vScroll.setVisible(totalRows * itemHeight > this.getSize().y);
    }

    private void onPaint(PaintEvent e) {
        this.paintList(e.gc, null);
    }

    private void paintList(@NotNull GC gc, @Nullable AdvancedListItem[] redrawItems) {
        Point itemSize = this.getItemSize();
        int itemsPerRow = this.getItemsPerRow();
        int itemRowsVisible = this.getVisibleRowCount() + 1;
        this.topRowOffset = this.vScroll.getSelection();
        this.topRowIndex = this.topRowOffset / itemSize.y;
        this.topRowOffset -= this.topRowIndex * itemSize.y;
        int topItemIndex = this.topRowIndex * itemsPerRow;
        int x = 0;
        int y = -this.topRowOffset;
        int i = 0;
        while (i < itemRowsVisible) {
            if (topItemIndex + i * itemsPerRow >= this.items.size()) break;
            int k = 0;
            while (k < itemsPerRow) {
                int itemIndex = topItemIndex + i * itemsPerRow + k;
                if (itemIndex >= this.items.size()) break;
                AdvancedListItem item = this.items.get(itemIndex);
                if (redrawItems == null || ArrayUtils.contains((Object[])redrawItems, (Object)item)) {
                    item.painItem(gc, x, y);
                }
                x += itemSize.x;
                ++k;
            }
            y += itemSize.y;
            x = 0;
            ++i;
        }
    }

    private int getVisibleRowCount() {
        return this.getSize().y / this.getItemSize().y + 1;
    }

    Point getItemSize() {
        Point imageSize = this.getImageSize();
        int itemLength = imageSize.x + 20 + this.getTextSize().y;
        return new Point(itemLength, itemLength + 10);
    }

    private int getItemsPerRow() {
        Point itemSize = this.getItemSize();
        Point containerSize = this.getSize();
        return Math.floorDiv(containerSize.x, itemSize.x);
    }

    private void navigateByKey(KeyEvent e) {
        if (this.selectedItem == null) {
            return;
        }
        int itemIndex = this.items.indexOf(this.selectedItem);
        int itemsPerRow = this.getItemsPerRow();
        switch (e.keyCode) {
            case 0x1000003: {
                if (itemIndex <= 0) break;
                this.setSelection(this.items.get(itemIndex - 1));
                break;
            }
            case 0x1000004: {
                if (itemIndex >= this.items.size() - 1) break;
                this.setSelection(this.items.get(itemIndex + 1));
                break;
            }
            case 0x1000001: {
                if (itemIndex < itemsPerRow) break;
                this.setSelection(this.items.get(itemIndex - itemsPerRow));
                break;
            }
            case 0x1000002: {
                if (itemIndex >= this.items.size() - 1) break;
                int nextIndex = itemIndex + itemsPerRow;
                if (nextIndex >= this.items.size() - 1) {
                    nextIndex = this.items.size() - 1;
                }
                this.setSelection(this.items.get(nextIndex));
                break;
            }
            case 0x1000005: {
                if ((itemIndex -= itemsPerRow * this.getVisibleRowCount()) < 0) {
                    itemIndex = 0;
                }
                this.setSelection(this.items.get(itemIndex));
                break;
            }
            case 0x1000006: {
                if ((itemIndex += itemsPerRow * this.getVisibleRowCount()) > this.items.size() - 1) {
                    itemIndex = this.items.size() - 1;
                }
                this.setSelection(this.items.get(itemIndex));
                break;
            }
            case 0x1000007: {
                if (this.items.isEmpty()) break;
                this.setSelection(this.items.get(0));
                break;
            }
            case 0x1000008: {
                if (this.items.isEmpty()) break;
                this.setSelection(this.items.get(this.items.size() - 1));
                break;
            }
            case 13: {
                this.notifyDefaultSelection();
            }
        }
        this.showItem(this.selectedItem);
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    Color getForegroundColor() {
        return this.foregroundColor;
    }

    Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    Color getHoverBackgroundColor() {
        return this.hoverBackgroundColor;
    }

    Point getTextSize() {
        return this.textSize;
    }

    public Point getImageSize() {
        return this.itemSize;
    }

    public void setItemSize(Point itemSize) {
        this.itemSize = itemSize;
    }

    void addItem(AdvancedListItem item) {
        this.items.add(item);
    }

    void removeItem(AdvancedListItem item) {
        this.items.remove(item);
    }

    public AdvancedListItem[] getItems() {
        return this.items.toArray(new AdvancedListItem[0]);
    }

    AdvancedListItem getHoverItem() {
        return this.hoverItem;
    }

    public AdvancedListItem getSelectedItem() {
        return this.selectedItem;
    }

    void setSelection(AdvancedListItem item) {
        if (this.selectedItem == item) {
            return;
        }
        this.selectedItem = item;
        Event event = new Event();
        event.widget = this;
        this.notifyListeners(13, event);
        this.redraw();
        if (this.isFocusControl()) {
            Object[] objectArray = new Object[2];
            objectArray[1] = item.getData();
            this.getAccessible().sendEvent(32780, (Object)objectArray);
        }
    }

    void notifyDefaultSelection() {
        Event event = new Event();
        event.widget = this;
        this.notifyListeners(14, event);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeAll() {
        this.checkWidget();
        this.setSelection(null);
        this.items.clear();
    }

    private void showItem(AdvancedListItem item) {
        if (!this.vScroll.isVisible()) {
            return;
        }
        int itemIndex = this.items.indexOf(item);
        int itemRow = itemIndex / this.getItemsPerRow();
        if (itemRow < this.topRowIndex) {
            if (itemRow < this.topRowIndex - 1) {
                this.vScroll.setSelection(itemRow * this.getItemSize().y);
            } else {
                this.vScroll.setSelection(Math.max(0, this.vScroll.getSelection() - this.vScroll.getPageIncrement()));
            }
        } else {
            int bottomRowIndex = this.topRowIndex + this.getVisibleRowCount();
            if (itemRow >= bottomRowIndex) {
                if (itemRow > bottomRowIndex + 1) {
                    this.vScroll.setSelection(itemRow * this.getItemSize().y);
                } else {
                    this.vScroll.setSelection(this.vScroll.getSelection() + this.vScroll.getPageIncrement());
                }
            }
        }
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                AdvancedListItem item = AdvancedList.this.getSelectedItem();
                if (item != null) {
                    e.result = item.getLabelProvider().getText(item.getData());
                }
            }
        });
    }
}

