/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.bigquery.model;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.bigquery.model.BigQuerySQLDialect;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class BigQueryDataSource
extends GenericDataSource {
    public BigQueryDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new BigQuerySQLDialect());
    }

    protected String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        String connectionURL = super.getConnectionURL(connectionInfo);
        if (CommonUtils.isNotEmpty((String)connectionURL) && (connectionURL.contains("OAuthPvtKeyPath={server};") || connectionURL.contains("OAuthServiceAcctEmail=;"))) {
            DBPDriver driver = this.getContainer().getDriver();
            return driver.getDataSourceProvider().getConnectionURL(driver, connectionInfo);
        }
        return connectionURL;
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("ProjectId", connectionInfo.getDatabaseName());
        if (connectionInfo.getUserName() != null) {
            props.put("OAuthServiceAcctEmail", connectionInfo.getUserName());
        } else {
            props.put("OAuthServiceAcctEmail", "");
        }
        return props;
    }
}

