/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.analyzer;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.analyzer.TableReferencesAnalyzer;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.utils.CommonUtils;

public class TableReferencesAnalyzerOld
implements TableReferencesAnalyzer {
    private SQLCompletionRequest request;
    private Log log = Log.getLog(TableReferencesAnalyzerOld.class);

    public TableReferencesAnalyzerOld(SQLCompletionRequest request) {
        this.request = request;
    }

    @Override
    @NotNull
    public Map<String, String> getFilteredTableReferences(@NotNull String tableAlias, boolean allowPartialMatch) {
        SQLScriptElement activeQuery = this.request.getActiveQuery();
        if (activeQuery == null) {
            return Collections.emptyMap();
        }
        IDocument document = this.request.getDocument();
        SQLRuleManager ruleManager = this.request.getContext().getRuleManager();
        TPRuleBasedScanner scanner = new TPRuleBasedScanner();
        scanner.setRules(ruleManager.getAllRules());
        scanner.setRange(document, activeQuery.getOffset(), activeQuery.getLength());
        TreeMap<String, String> tableRefs = new TreeMap<String, String>();
        try {
            TPToken tok;
            InlineState state = InlineState.UNMATCHED;
            String matchedTableName = null;
            String matchedTableAlias = null;
            char structSeparator = this.request.getContext().getSyntaxManager().getStructSeparator();
            boolean prevTokenWasMatchAttempt = false;
            while (!(tok = scanner.nextToken()).isEOF()) {
                if (!(tok instanceof TPTokenAbstract) || tok.isWhitespace()) continue;
                String value = document.get(scanner.getTokenOffset(), scanner.getTokenLength());
                if (state == InlineState.UNMATCHED && (TableReferencesAnalyzerOld.isTableQueryToken(tok, value) || prevTokenWasMatchAttempt && ",".equals(value))) {
                    state = InlineState.TABLE_NAME;
                    continue;
                }
                if ((state == InlineState.TABLE_DOT || state == InlineState.ALIAS_AS) && ",".equals(value)) {
                    if (!CommonUtils.isEmpty(matchedTableName) && (CommonUtils.isEmpty((String)tableAlias) || CommonUtils.equalObjects((Object)tableAlias, (Object)matchedTableAlias))) {
                        if (matchedTableAlias == null) {
                            matchedTableAlias = matchedTableName;
                        }
                        tableRefs.put(matchedTableName, matchedTableAlias);
                    }
                    matchedTableName = null;
                    state = InlineState.TABLE_NAME;
                    continue;
                }
                if (state == InlineState.TABLE_NAME && TableReferencesAnalyzer.isNamePartToken(tok)) {
                    matchedTableName = String.valueOf(CommonUtils.notEmpty(matchedTableName)) + value;
                    state = InlineState.TABLE_DOT;
                    continue;
                }
                if (state == InlineState.TABLE_DOT && value.indexOf(structSeparator) >= 0) {
                    matchedTableName = String.valueOf(matchedTableName) + value;
                    state = InlineState.TABLE_NAME;
                    continue;
                }
                if (state == InlineState.TABLE_DOT) {
                    if (CommonUtils.isEmpty((String)tableAlias) && !TableReferencesAnalyzerOld.isTableQueryToken(tok, value)) {
                        state = InlineState.MATCHED;
                    } else {
                        if (TableReferencesAnalyzerOld.isTableQueryToken(tok, value)) {
                            matchedTableName = null;
                            state = InlineState.TABLE_NAME;
                            continue;
                        }
                        state = InlineState.ALIAS_AS;
                    }
                }
                if (state == InlineState.ALIAS_AS && tok.getData() == SQLTokenType.T_KEYWORD && "AS".equalsIgnoreCase(value)) {
                    state = InlineState.ALIAS_NAME;
                    continue;
                }
                if (tok.getData() == SQLTokenType.T_KEYWORD) {
                    InlineState inlineState = state = CommonUtils.isEmpty((String)matchedTableName) ? InlineState.UNMATCHED : InlineState.MATCHED;
                }
                if ((state == InlineState.ALIAS_AS || state == InlineState.ALIAS_NAME) && TableReferencesAnalyzer.isNamePartToken(tok)) {
                    matchedTableAlias = value;
                    state = InlineState.MATCHED;
                }
                if (state == InlineState.MATCHED) {
                    boolean partialMatch;
                    prevTokenWasMatchAttempt = true;
                    boolean fullMatch = CommonUtils.isEmpty((String)tableAlias) || tableAlias.equalsIgnoreCase(matchedTableAlias);
                    boolean bl = partialMatch = fullMatch || allowPartialMatch && CommonUtils.startsWithIgnoreCase((String)matchedTableAlias, (String)tableAlias);
                    if (fullMatch || partialMatch) {
                        if (matchedTableAlias == null) {
                            matchedTableAlias = matchedTableName;
                        }
                        tableRefs.put(matchedTableName, matchedTableAlias);
                    }
                    state = InlineState.UNMATCHED;
                    matchedTableName = null;
                    matchedTableAlias = null;
                    continue;
                }
                prevTokenWasMatchAttempt = false;
            }
            if (!CommonUtils.isEmpty(matchedTableName) && (CommonUtils.isEmpty((String)tableAlias) || CommonUtils.equalObjects((Object)tableAlias, matchedTableAlias))) {
                if (matchedTableAlias == null) {
                    matchedTableAlias = "";
                }
                tableRefs.put(matchedTableName, matchedTableAlias);
            }
        }
        catch (BadLocationException e) {
            this.log.debug((Object)e);
        }
        return tableRefs;
    }

    @Override
    public Map<String, String> getTableAliasesFromQuery(String query) {
        return Collections.emptyMap();
    }

    private static boolean isTableQueryToken(TPToken tok, String value) {
        return tok.getData() == SQLTokenType.T_KEYWORD && (value.equalsIgnoreCase("FROM") || value.equalsIgnoreCase("UPDATE") || value.equalsIgnoreCase("JOIN") || value.equalsIgnoreCase("INTO"));
    }

    private static enum InlineState {
        UNMATCHED,
        TABLE_NAME,
        TABLE_DOT,
        ALIAS_AS,
        ALIAS_NAME,
        MATCHED;

    }
}

